/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterfortresses.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LiquidBlockProcessor
extends StructureProcessor {
    public static final Codec<LiquidBlockProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("target_block").forGetter(config -> config.targetBlock), (App)BlockState.CODEC.fieldOf("target_block_output").forGetter(config -> config.targetBlockOutput)).apply((Applicative)instance, instance.stable(LiquidBlockProcessor::new)));
    public final BlockState targetBlock;
    public final BlockState targetBlockOutput;

    private LiquidBlockProcessor(BlockState targetBlock, BlockState targetBlockOutput) {
        this.targetBlock = targetBlock;
        this.targetBlockOutput = targetBlockOutput;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().is(this.targetBlock.getBlock())) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), this.targetBlockOutput, blockInfoGlobal.nbt());
            if (levelReader instanceof WorldGenRegion) {
                worldGenRegion = (WorldGenRegion)levelReader;
                worldGenRegion.scheduleTick(blockInfoGlobal.pos(), (Fluid)Fluids.LAVA, 0);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.LIQUID_BLOCK_PROCESSOR;
    }
}

