/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.client.handler;

import com.mojang.serialization.DynamicOps;
import fuzs.effectdescriptions.EffectDescriptions;
import fuzs.effectdescriptions.client.helper.EffectLinesHelper;
import fuzs.effectdescriptions.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class ItemTooltipHandler {
    public static void onItemTooltip(ItemStack stack, @Nullable Player player, List<Component> lines, TooltipFlag context) {
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addDescriptionsToItemTooltips) {
            return;
        }
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).effectDescriptionItems.contains((Object)stack.getItem())) {
            return;
        }
        if (((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).holdShiftForItemDescriptions && !Screen.hasShiftDown()) {
            return;
        }
        Set ids = ItemTooltipHandler.getMobEffects(stack).stream().map(MobEffectInstance::getDescriptionId).collect(Collectors.toSet());
        for (int i = 0; i < lines.size(); ++i) {
            Component component2;
            Object object;
            Component line = lines.get(i);
            ComponentContents componentContents = line.getContents();
            if (!(componentContents instanceof TranslatableContents)) continue;
            TranslatableContents contents = (TranslatableContents)componentContents;
            while (contents.getArgs().length != 0 && (object = contents.getArgs()[0]) instanceof Component && (object = (component2 = (Component)object).getContents()) instanceof TranslatableContents) {
                TranslatableContents innerContents;
                contents = innerContents = (TranslatableContents)object;
            }
            String id = contents.getKey();
            if (!ids.contains(id)) continue;
            int index = i + 1;
            EffectLinesHelper.getEffectDescriptionComponent(id, false).ifPresent(component -> lines.add(index, (Component)component));
        }
    }

    private static List<MobEffectInstance> getMobEffects(ItemStack stack) {
        if (stack.is(Items.SUSPICIOUS_STEW)) {
            ArrayList suspiciousStewEffects = Lists.newArrayList();
            ItemTooltipHandler.getSuspiciousStewPotionEffects(stack, suspiciousStewEffects::add);
            return suspiciousStewEffects;
        }
        return PotionUtils.getMobEffects((ItemStack)stack);
    }

    private static void getSuspiciousStewPotionEffects(ItemStack itemStack, Consumer<MobEffectInstance> consumer) {
        CompoundTag compoundTag = itemStack.getTag();
        if (compoundTag != null && compoundTag.contains("effects", 9)) {
            SuspiciousEffectHolder.EffectEntry.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.getList("effects", 10)).result().ifPresent(list -> list.forEach(effectEntry -> consumer.accept(effectEntry.createEffectInstance())));
        }
    }
}

