/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.client.helper;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import fuzs.effectdescriptions.EffectDescriptions;
import fuzs.effectdescriptions.config.ClientConfig;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.AttributeModifierTemplate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class EffectLinesHelper {
    public static Optional<Component> getEffectDescriptionComponent(String id, boolean preventIndentation) {
        String descriptionKey = EffectLinesHelper.getDescriptionTranslationKey(id);
        if (descriptionKey != null) {
            int indentation;
            MutableComponent component = Component.translatable((String)descriptionKey);
            if (!preventIndentation && (indentation = ((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).descriptionIndentation) > 0) {
                component = Component.literal((String)StringUtils.repeat((String)" ", (int)indentation)).append((Component)component);
            }
            return Optional.of(component.withStyle(ChatFormatting.GRAY));
        }
        return Optional.empty();
    }

    @Nullable
    private static String getDescriptionTranslationKey(String id) {
        if (Language.getInstance().has(id + ".desc")) {
            return id + ".desc";
        }
        if (Language.getInstance().has(id + ".description")) {
            return id + ".description";
        }
        if (Language.getInstance().has("description." + id)) {
            return "description." + id;
        }
        return null;
    }

    public static void tryAddDisplayName(Minecraft minecraft, List<Component> lines, MobEffectInstance mobEffectInstance, boolean smallWidgets) {
        if (smallWidgets || ((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).alwaysAddEffectNameToTooltips) {
            MutableComponent effectComponent = Component.translatable((String)mobEffectInstance.getDescriptionId());
            if (mobEffectInstance.getAmplifier() > 0) {
                effectComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{effectComponent, Component.translatable((String)("potion.potency." + mobEffectInstance.getAmplifier()))});
            }
            if (!mobEffectInstance.isInfiniteDuration()) {
                float tickrate = minecraft.level.tickRateManager().tickrate();
                MutableComponent durationComponent = Component.literal((String)"(").append(MobEffectUtil.formatDuration((MobEffectInstance)mobEffectInstance, (float)1.0f, (float)tickrate)).append(")");
                effectComponent.append(CommonComponents.SPACE).append((Component)durationComponent);
            }
            effectComponent.withStyle(mobEffectInstance.getEffect().getCategory().getTooltipFormatting());
            lines.add((Component)effectComponent);
        }
    }

    public static void tryAddAttributes(List<Component> lines, MobEffectInstance mobEffectInstance) {
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addAttributesToWidgetTooltips) {
            return;
        }
        List<Pair<Attribute, AttributeModifier>> attributes = EffectLinesHelper.getAttributesFromEffects(List.of(mobEffectInstance));
        if (!attributes.isEmpty()) {
            lines.add(CommonComponents.EMPTY);
            lines.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair<Attribute, AttributeModifier> pair : attributes) {
                AttributeModifier attributeModifier = (AttributeModifier)pair.getSecond();
                double d0 = attributeModifier.getAmount();
                double d1 = attributeModifier.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && attributeModifier.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributeModifier.getAmount() : attributeModifier.getAmount() * 100.0;
                if (d0 > 0.0) {
                    lines.add((Component)Component.translatable((String)("attribute.modifier.plus." + attributeModifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lines.add((Component)Component.translatable((String)("attribute.modifier.take." + attributeModifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }

    private static List<Pair<Attribute, AttributeModifier>> getAttributesFromEffects(List<MobEffectInstance> effects) {
        ArrayList attributes = Lists.newArrayList();
        for (MobEffectInstance mobeffectinstance : effects) {
            for (Map.Entry entry : mobeffectinstance.getEffect().getAttributeModifiers().entrySet()) {
                attributes.add(new Pair((Object)((Attribute)entry.getKey()), (Object)((AttributeModifierTemplate)entry.getValue()).create(mobeffectinstance.getAmplifier())));
            }
        }
        return attributes;
    }

    private static ChatFormatting getMobEffectColor(MobEffect mobEffect) {
        return switch (mobEffect.getCategory()) {
            case MobEffectCategory.BENEFICIAL -> ChatFormatting.BLUE;
            case MobEffectCategory.HARMFUL -> ChatFormatting.RED;
            default -> ChatFormatting.GOLD;
        };
    }

    public static void tryAddModName(List<Component> lines, MobEffectInstance mobEffectInstance) {
        if (((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addModNameToWidgetTooltips) {
            ModLoaderEnvironment.INSTANCE.getModContainer(BuiltInRegistries.MOB_EFFECT.getKey((Object)mobEffectInstance.getEffect()).getNamespace()).map(ModContainer::getDisplayName).map(s -> Component.literal((String)s).withStyle(ChatFormatting.BLUE)).ifPresent(lines::add);
        }
    }

    public static void tryAddInternalName(List<Component> lines, MobEffectInstance mobEffectInstance) {
        if (((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addInternalIdToWidgetTooltips) {
            lines.add((Component)Component.literal((String)BuiltInRegistries.MOB_EFFECT.getKey((Object)mobEffectInstance.getEffect()).toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

