/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.config;

import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ClientConfig
implements ConfigCore {
    @Config(description={"Add effect descriptions to item tooltips."})
    public boolean addDescriptionsToItemTooltips = true;
    @Config(description={"Items that should support descriptions for the effects on their inventory tooltip.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."})
    List<String> effectDescriptionItemsRaw = KeyedValueProvider.toString((ResourceKey)Registries.ITEM, (Object[])new Item[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION, Items.TIPPED_ARROW, Items.SUSPICIOUS_STEW});
    @Config(description={"Amount of spaces to add at the beginning of an effect description."})
    @Config.IntRange(min=0)
    public int descriptionIndentation = 0;
    @Config(description={"Only reveal effect descriptions for items while any shift key is held."})
    public boolean holdShiftForItemDescriptions = false;
    @Config(description={"Add effect descriptions to effect widget tooltips in the survival and creative inventory screens."})
    public boolean addDescriptionsToWidgetTooltips = true;
    @Config(description={"Add the effect name and duration to every effect widget tooltip, even if the widget already contains both."})
    public boolean alwaysAddEffectNameToTooltips = true;
    @Config(description={"Add attributes granted by an effect to effect widget tooltips."})
    public boolean addAttributesToWidgetTooltips = true;
    @Config(description={"Add the internal id of an effect to effect widget tooltips."})
    public boolean addInternalIdToWidgetTooltips = false;
    @Config(description={"Add the name of the mod that added an effect to effect widget tooltips."})
    public boolean addModNameToWidgetTooltips = false;
    public ConfigDataSet<Item> effectDescriptionItems;

    public void afterConfigReload() {
        this.effectDescriptionItems = ConfigDataSet.from((ResourceKey)Registries.ITEM, this.effectDescriptionItemsRaw, (Class[])new Class[0]);
    }
}

