/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholdsCommon;
import com.yungnickyoung.minecraft.betterstrongholds.module.StructureProcessorTypeModule;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class CobwebProcessor
extends StructureProcessor {
    public static final CobwebProcessor INSTANCE = new CobwebProcessor();
    public static final Codec<CobwebProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().is(Blocks.TRIPWIRE) || blockInfoGlobal.state().is(Blocks.COBWEB)) {
            RandomSource randomSource = structurePlacementData.getRandom(blockInfoGlobal.pos());
            double replacementChance = this.getReplacementChance(blockInfoGlobal.state());
            blockInfoGlobal = randomSource.nextDouble() < replacementChance ? new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.COBWEB.defaultBlockState(), blockInfoGlobal.nbt()) : new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.AIR.defaultBlockState(), blockInfoGlobal.nbt());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.COBWEB_PROCESSOR;
    }

    private double getReplacementChance(BlockState blockState) {
        if (blockState.is(Blocks.TRIPWIRE)) {
            return BetterStrongholdsCommon.CONFIG.general.cobwebReplacementChanceNormal;
        }
        if (blockState.is(Blocks.COBWEB)) {
            return BetterStrongholdsCommon.CONFIG.general.cobwebReplacementChanceSpawner;
        }
        return 0.0;
    }
}

