/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.processor.ISafeWorldModifier;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class WaterloggedProcessor
extends StructureProcessor
implements ISafeWorldModifier {
    public static final WaterloggedProcessor INSTANCE = new WaterloggedProcessor();
    public static final Codec<WaterloggedProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().hasProperty((Property)BlockStateProperties.WATERLOGGED) && !((Boolean)blockInfoGlobal.state().getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            ChunkPos currentChunkPos = new ChunkPos(blockInfoGlobal.pos());
            ChunkAccess currentChunk = levelReader.getChunk(currentChunkPos.x, currentChunkPos.z);
            int sectionYIndex = currentChunk.getSectionIndex(blockInfoGlobal.pos().getY());
            if (sectionYIndex < 0) {
                return blockInfoGlobal;
            }
            LevelChunkSection currChunkSection = currentChunk.getSection(sectionYIndex);
            if (this.getFluidStateSafe(levelReader, blockInfoGlobal.pos()).is(FluidTags.WATER)) {
                this.setBlockStateSafe(levelReader, blockInfoGlobal.pos(), Blocks.STONE_BRICKS.defaultBlockState());
            }
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                Optional blockState;
                mutable.set((Vec3i)blockInfoGlobal.pos()).move(direction);
                if (currentChunkPos.x != mutable.getX() >> 4 || currentChunkPos.z != mutable.getZ() >> 4) {
                    currentChunkPos = new ChunkPos((BlockPos)mutable);
                    currentChunk = levelReader.getChunk(currentChunkPos.x, currentChunkPos.z);
                    sectionYIndex = currentChunk.getSectionIndex(mutable.getY());
                    if (sectionYIndex < 0) {
                        return blockInfoGlobal;
                    }
                    currChunkSection = currentChunk.getSection(sectionYIndex);
                }
                if (!this.getFluidStateSafe(currChunkSection, (BlockPos)mutable).is(FluidTags.WATER) || !(blockState = this.getBlockStateSafe(currChunkSection, (BlockPos)mutable)).isPresent() || ((BlockState)blockState.get()).hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)((BlockState)blockState.get()).getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) continue;
                this.setBlockStateSafe(currChunkSection, (BlockPos)mutable, Blocks.STONE_BRICKS.defaultBlockState());
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.WATERLOGGED_PROCESSOR;
    }
}

