/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block;

import com.mojang.serialization.MapCodec;
import dev.ftb.mods.ftbquests.block.entity.DetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class DetectorBlock
extends BaseEntityBlock {
    private static final MapCodec<DetectorBlock> CODEC = DetectorBlock.simpleCodec(DetectorBlock::new);
    public static final BlockBehaviour.Properties PROPS = BlockBehaviour.Properties.of().strength(0.3f);

    public DetectorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DetectorBlockEntity(blockPos, blockState);
    }

    protected MapCodec<DetectorBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        boolean wasPowered;
        if (!level.isClientSide() && (wasPowered = ((Boolean)blockState.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) != level.hasNeighborSignal(blockPos)) {
            BlockEntity blockEntity;
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(!wasPowered)), 2);
            if (!wasPowered && (blockEntity = level.getBlockEntity(blockPos)) instanceof DetectorBlockEntity) {
                DetectorBlockEntity dbe = (DetectorBlockEntity)blockEntity;
                dbe.onPowered(level, blockPos);
            }
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide() && stack.hasCustomHoverName() && (blockEntity = level.getBlockEntity(pos)) instanceof DetectorBlockEntity) {
            DetectorBlockEntity dbe = (DetectorBlockEntity)blockEntity;
            dbe.update(stack.getHoverName().getString());
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }
}

