/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block;

import com.mojang.serialization.MapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftbquests.block.entity.LootCrateOpenerBlockEntity;
import dev.ftb.mods.ftbquests.block.neoforge.LootCrateOpenerBlockImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LootCrateOpenerBlock
extends BaseEntityBlock {
    private static final MapCodec<LootCrateOpenerBlock> CODEC = LootCrateOpenerBlock.simpleCodec(LootCrateOpenerBlock::new);
    public static final BlockBehaviour.Properties PROPS = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(1.8f);

    public LootCrateOpenerBlock(BlockBehaviour.Properties props) {
        super(PROPS);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return LootCrateOpenerBlock.blockEntityProvider().create(blockPos, blockState);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<LootCrateOpenerBlockEntity> blockEntityProvider() {
        return LootCrateOpenerBlockImpl.blockEntityProvider();
    }

    protected MapCodec<LootCrateOpenerBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult use(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(blockPos)) instanceof LootCrateOpenerBlockEntity) {
            LootCrateOpenerBlockEntity opener = (LootCrateOpenerBlockEntity)blockEntity;
            player.displayClientMessage((Component)Component.translatable((String)"block.ftbquests.loot_crate_opener.rightclick", (Object[])new Object[]{opener.getOutputCount()}), true);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.setPlacedBy(level, blockPos, blockState, livingEntity, itemStack);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof LootCrateOpenerBlockEntity) {
            LootCrateOpenerBlockEntity opener = (LootCrateOpenerBlockEntity)blockEntity;
            if (livingEntity instanceof Player) {
                opener.setOwner(livingEntity.getUUID());
            }
        }
    }
}

