/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenAuxBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.block.neoforge.TaskScreenBlockImpl;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.item.ScreenBlockItem;
import dev.ftb.mods.ftbquests.net.TaskScreenConfigRequest;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TaskScreenBlock
extends BaseEntityBlock {
    private static final MapCodec<TaskScreenBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TaskScreenBlock.propertiesCodec()).and((App)Codec.INT.fieldOf("size").forGetter(TaskScreenBlock::getSize)).apply((Applicative)instance, TaskScreenBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BlockBehaviour.Properties PROPS = BlockBehaviour.Properties.of().mapColor(DyeColor.BLACK).strength(0.3f);
    private final int size;

    protected TaskScreenBlock(BlockBehaviour.Properties props, int size) {
        super(props);
        this.size = size;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public int getSize() {
        return this.size;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return TaskScreenBlock.blockEntityProvider().create(blockPos, blockState);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<TaskScreenBlockEntity> blockEntityProvider() {
        return TaskScreenBlockImpl.blockEntityProvider();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<TaskScreenAuxBlockEntity> blockEntityAuxProvider() {
        return TaskScreenBlockImpl.blockEntityAuxProvider();
    }

    protected MapCodec<? extends TaskScreenBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        if (!this.validatePlaceable(blockPlaceContext)) {
            return null;
        }
        return (BlockState)super.getStateForPlacement(blockPlaceContext).setValue((Property)FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
    }

    private boolean validatePlaceable(BlockPlaceContext ctx) {
        int screenSize = ScreenBlockItem.getSize(ctx.getItemInHand());
        if (screenSize == 1) {
            return true;
        }
        Direction facing = ctx.getHorizontalDirection();
        return BlockPos.betweenClosedStream((BoundingBox)TaskScreenBlock.getMultiblockBounds(ctx.getClickedPos(), this.getSize(), facing)).allMatch(pos -> ctx.getLevel().getBlockState(pos).canBeReplaced(ctx));
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.setPlacedBy(level, blockPos, blockState, livingEntity, itemStack);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)blockEntity;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)livingEntity;
                coreScreen.setTeamId(ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)sp).getTeamId());
            }
            Direction facing = (Direction)blockState.getValue((Property)FACING);
            BlockState auxState = (BlockState)((Block)FTBQuestsBlocks.AUX_SCREEN.get()).defaultBlockState().setValue((Property)FACING, (Comparable)facing);
            BlockPos.betweenClosedStream((BoundingBox)TaskScreenBlock.getMultiblockBounds(blockPos, this.getSize(), facing)).filter(pos -> !pos.equals((Object)blockPos)).forEach(auxPos -> {
                level.setBlockAndUpdate(auxPos, auxState);
                BlockEntity patt5864$temp = level.getBlockEntity(auxPos);
                if (patt5864$temp instanceof TaskScreenAuxBlockEntity) {
                    TaskScreenAuxBlockEntity auxScreen = (TaskScreenAuxBlockEntity)patt5864$temp;
                    auxScreen.setCoreScreen(coreScreen);
                }
            });
        }
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (blockState.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(blockPos)) instanceof ITaskScreen) {
            ITaskScreen taskScreen = (ITaskScreen)blockEntity;
            taskScreen.getCoreScreen().ifPresent(coreScreen -> {
                coreScreen.removeAllAuxScreens();
                if (coreScreen != taskScreen) {
                    level.destroyBlock(coreScreen.getBlockPos(), true, null);
                }
            });
            super.onRemove(blockState, level, blockPos, newState, isMoving);
        }
    }

    public float getDestroyProgress(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos) {
        ITaskScreen taskScreen;
        BlockEntity blockEntity = player.level().getBlockEntity(blockPos);
        if (blockEntity instanceof ITaskScreen && (taskScreen = (ITaskScreen)blockEntity).isIndestructible()) {
            return 0.0f;
        }
        return super.getDestroyProgress(blockState, player, blockGetter, blockPos);
    }

    public InteractionResult use(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof ITaskScreen) {
                ITaskScreen taskScreen = (ITaskScreen)blockEntity;
                if (TaskScreenBlock.hasPermissionToEdit(sp, taskScreen)) {
                    taskScreen.getCoreScreen().ifPresent(coreScreen -> new TaskScreenConfigRequest(coreScreen.getBlockPos()).sendTo(sp));
                } else {
                    sp.displayClientMessage((Component)Component.translatable((String)"block.ftbquests.screen.no_permission").withStyle(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void appendHoverText(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, blockGetter, list, tooltipFlag);
        if (itemStack.getTag() != null && itemStack.getTag().contains("BlockEntityTag", 10)) {
            Task task;
            CompoundTag subTag = Objects.requireNonNull(itemStack.getTagElement("BlockEntityTag"));
            BaseQuestFile questFile = FTBQuestsClient.getClientQuestFile();
            if (questFile != null && (task = questFile.getTask(subTag.getLong("TaskID"))) != null) {
                list.add((Component)Component.translatable((String)"ftbquests.chapter").append(": ").append((Component)task.getQuest().getChapter().getTitle().copy().withStyle(ChatFormatting.YELLOW)));
                list.add((Component)Component.translatable((String)"ftbquests.quest").append(": ").append((Component)task.getQuest().getMutableTitle().withStyle(ChatFormatting.YELLOW)));
                list.add((Component)Component.translatable((String)"ftbquests.task").append(": ").append((Component)task.getMutableTitle().withStyle(ChatFormatting.YELLOW)));
            }
        }
    }

    public static boolean hasPermissionToEdit(ServerPlayer player, ITaskScreen screen) {
        if (player.getUUID().equals(screen.getTeamId())) {
            return true;
        }
        return FTBTeamsAPI.api().getManager().getTeamByID(screen.getTeamId()).map(team -> team.getRankForPlayer(player.getUUID()).isMemberOrBetter()).orElse(false);
    }

    public static BoundingBox getMultiblockBounds(BlockPos corePos, int size, Direction facing) {
        if (size == 1) {
            return new BoundingBox(corePos);
        }
        int size2 = size / 2;
        facing = facing.getCounterClockWise();
        BlockPos pos1 = new BlockPos(corePos.getX() - size2 * facing.getStepX(), corePos.getY(), corePos.getZ() - size2 * facing.getStepZ());
        BlockPos pos2 = new BlockPos(corePos.getX() + size2 * facing.getStepX(), corePos.getY() + size - 1, corePos.getZ() + size2 * facing.getStepZ());
        return BoundingBox.fromCorners((Vec3i)pos1, (Vec3i)pos2);
    }

    public static class Aux
    extends TaskScreenBlock {
        private static final MapCodec<Aux> CODEC = Aux.simpleCodec(Aux::new);

        protected Aux(BlockBehaviour.Properties props) {
            super(props, 0);
        }

        @Override
        @Nullable
        public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
            return Aux.blockEntityAuxProvider().create(blockPos, blockState);
        }

        protected MapCodec<Aux> codec() {
            return CODEC;
        }
    }
}

