/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import dev.ftb.mods.ftbquests.block.entity.FTBQuestsBlockEntities;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TaskScreenAuxBlockEntity
extends BlockEntity
implements ITaskScreen,
Nameable {
    @NotNull
    private WeakReference<TaskScreenBlockEntity> coreScreen = new WeakReference<Object>(null);
    private BlockPos corePosPending;

    public TaskScreenAuxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)FTBQuestsBlockEntities.AUX_TASK_SCREEN.get(), blockPos, blockState);
    }

    public Component getName() {
        return (Component)this.getCoreScreen().map(s -> s.getBlockState().getBlock().getName()).orElse(Component.literal((String)"Task Screen"));
    }

    @Override
    public Optional<TaskScreenBlockEntity> getCoreScreen() {
        if (this.corePosPending != null) {
            TaskScreenBlockEntity core = this.level.getBlockEntity(this.corePosPending, (BlockEntityType)FTBQuestsBlockEntities.CORE_TASK_SCREEN.get()).orElse(null);
            if (core != null) {
                this.coreScreen = new WeakReference<TaskScreenBlockEntity>(core);
                this.corePosPending = null;
            } else {
                this.level.destroyBlock(this.getBlockPos(), false, null);
            }
        }
        return Optional.ofNullable((TaskScreenBlockEntity)this.coreScreen.get());
    }

    public void setCoreScreen(@NotNull TaskScreenBlockEntity coreScreen) {
        if (this.coreScreen.get() != null) {
            throw new IllegalStateException("coreScreen is already set and can't be changed!");
        }
        this.coreScreen = new WeakReference<TaskScreenBlockEntity>(coreScreen);
        this.setChanged();
    }

    public void load(CompoundTag compoundTag) {
        super.load(compoundTag);
        this.corePosPending = compoundTag.contains("CorePos") ? NbtUtils.readBlockPos((CompoundTag)compoundTag.getCompound("CorePos")) : null;
    }

    protected void saveAdditional(CompoundTag compoundTag) {
        super.saveAdditional(compoundTag);
        if (this.corePosPending != null) {
            compoundTag.put("CorePos", (Tag)NbtUtils.writeBlockPos((BlockPos)this.corePosPending));
        } else {
            TaskScreenBlockEntity cs = (TaskScreenBlockEntity)this.coreScreen.get();
            if (cs != null) {
                compoundTag.put("CorePos", (Tag)NbtUtils.writeBlockPos((BlockPos)cs.getBlockPos()));
            }
        }
    }

    @Override
    public boolean isIndestructible() {
        return this.getCoreScreen().map(TaskScreenBlockEntity::isIndestructible).orElse(false);
    }

    @Override
    public ItemStack getSkin() {
        return this.getCoreScreen().map(TaskScreenBlockEntity::getSkin).orElse(ItemStack.EMPTY);
    }

    @Override
    @NotNull
    public UUID getTeamId() {
        return this.getCoreScreen().map(TaskScreenBlockEntity::getTeamId).orElse(Util.NIL_UUID);
    }

    @Override
    public boolean isInputOnly() {
        return this.getCoreScreen().map(TaskScreenBlockEntity::isInputOnly).orElse(false);
    }
}

