/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import dev.ftb.mods.ftblibrary.config.BooleanConfig;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.FTBQuestsBlockEntities;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.net.TaskScreenConfigResponse;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskScreenBlockEntity
extends BlockEntity
implements ITaskScreen {
    private long taskId = 0L;
    private Task task = null;
    private boolean indestructible = false;
    private boolean inputOnly = false;
    private boolean textShadow = false;
    private ItemStack inputModeIcon = ItemStack.EMPTY;
    private ItemStack skin = ItemStack.EMPTY;
    @NotNull
    private UUID teamId = Util.NIL_UUID;
    public float[] fakeTextureUV = null;
    private TeamData cachedTeamData = null;

    public TaskScreenBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)FTBQuestsBlockEntities.CORE_TASK_SCREEN.get(), blockPos, blockState);
    }

    public Task getTask() {
        if (this.task == null && this.taskId != 0L || this.task != null && this.task.id != this.taskId) {
            this.task = FTBQuestsAPI.api().getQuestFile(this.level.isClientSide).getTask(this.taskId);
        }
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        this.taskId = task == null ? 0L : task.id;
        this.setChanged();
    }

    @Override
    public boolean isInputOnly() {
        return this.inputOnly;
    }

    public void setInputOnly(boolean inputOnly) {
        this.inputOnly = inputOnly;
        this.setChanged();
    }

    public ItemStack getInputModeIcon() {
        return this.inputModeIcon;
    }

    public void setInputModeIcon(ItemStack inputModeIcon) {
        this.inputModeIcon = inputModeIcon;
        this.setChanged();
    }

    @Override
    public boolean isIndestructible() {
        return this.indestructible;
    }

    public void setIndestructible(boolean indestructible) {
        this.indestructible = indestructible;
        this.setChanged();
    }

    @Override
    public ItemStack getSkin() {
        return this.skin;
    }

    public void setSkin(ItemStack skin) {
        this.skin = skin;
        this.fakeTextureUV = null;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public void setTeamId(@NotNull UUID teamId) {
        this.teamId = teamId;
        this.cachedTeamData = null;
    }

    @Override
    @NotNull
    public UUID getTeamId() {
        return this.teamId;
    }

    public TeamData getCachedTeamData() {
        if (this.cachedTeamData == null) {
            BaseQuestFile f = FTBQuestsAPI.api().getQuestFile(this.level.isClientSide);
            this.cachedTeamData = f.getNullableTeamData(this.getTeamId());
        }
        return this.cachedTeamData;
    }

    @Override
    public Optional<TaskScreenBlockEntity> getCoreScreen() {
        return Optional.of(this);
    }

    public void removeAllAuxScreens() {
        Block block;
        if (this.level != null && (block = this.getBlockState().getBlock()) instanceof TaskScreenBlock) {
            TaskScreenBlock tsb = (TaskScreenBlock)block;
            BlockPos.betweenClosedStream((BoundingBox)TaskScreenBlock.getMultiblockBounds(this.getBlockPos(), tsb.getSize(), (Direction)this.getBlockState().getValue((Property)TaskScreenBlock.FACING))).forEach(pos -> {
                if (this.level.getBlockState(pos).getBlock() == FTBQuestsBlocks.AUX_SCREEN.get()) {
                    this.level.removeBlock(pos, false);
                }
            });
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public void load(CompoundTag compoundTag) {
        super.load(compoundTag);
        this.teamId = compoundTag.hasUUID("TeamID") ? compoundTag.getUUID("TeamID") : Util.NIL_UUID;
        this.taskId = compoundTag.getLong("TaskID");
        this.skin = compoundTag.contains("Skin") ? ItemStack.of((CompoundTag)compoundTag.getCompound("Skin")) : ItemStack.EMPTY;
        this.indestructible = compoundTag.getBoolean("Indestructible");
        this.inputOnly = compoundTag.getBoolean("InputOnly");
        this.inputModeIcon = compoundTag.contains("InputModeIcon") ? ItemStack.of((CompoundTag)compoundTag.getCompound("InputModeIcon")) : ItemStack.EMPTY;
        this.textShadow = compoundTag.getBoolean("TextShadow");
        this.task = null;
        this.fakeTextureUV = null;
    }

    protected void saveAdditional(CompoundTag compoundTag) {
        super.saveAdditional(compoundTag);
        if (this.teamId != Util.NIL_UUID) {
            compoundTag.putUUID("TeamID", this.teamId);
        }
        if (this.taskId != 0L) {
            compoundTag.putLong("TaskID", this.taskId);
        }
        if (!this.skin.isEmpty()) {
            compoundTag.put("Skin", (Tag)this.skin.save(new CompoundTag()));
        }
        if (this.indestructible) {
            compoundTag.putBoolean("Indestructible", true);
        }
        if (this.inputOnly) {
            compoundTag.putBoolean("InputOnly", true);
        }
        if (!this.inputModeIcon.isEmpty()) {
            compoundTag.put("InputModeIcon", (Tag)this.inputModeIcon.save(new CompoundTag()));
        }
        if (this.textShadow) {
            compoundTag.putBoolean("TextShadow", true);
        }
    }

    public ConfigGroup fillConfigGroup(TeamData data) {
        ConfigGroup cg0 = new ConfigGroup("task_screen", accepted -> {
            if (accepted) {
                new TaskScreenConfigResponse(this).sendToServer();
            }
        });
        cg0.setNameKey(this.getBlockState().getBlock().getDescriptionId());
        ConfigGroup cg = cg0.getOrCreateSubgroup("screen");
        ((ConfigQuestObject)cg.add("task", new ConfigQuestObject(o -> this.isSuitableTask(data, (QuestObjectBase)o)), (Object)this.getTask(), this::setTask, null)).setNameKey("ftbquests.task");
        ((ItemStackConfig)cg.add("skin", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getSkin(), this::setSkin, (Object)ItemStack.EMPTY)).setNameKey("block.ftbquests.screen.skin");
        ((BooleanConfig)cg.add("text_shadow", (ConfigValue)new BooleanConfig(), (Object)this.isTextShadow(), this::setTextShadow, (Object)false)).setNameKey("block.ftbquests.screen.text_shadow");
        ((BooleanConfig)cg.add("indestructible", (ConfigValue)new BooleanConfig(), (Object)this.isIndestructible(), this::setIndestructible, (Object)false)).setNameKey("block.ftbquests.screen.indestructible");
        ((BooleanConfig)cg.add("input_only", (ConfigValue)new BooleanConfig(), (Object)this.isInputOnly(), this::setInputOnly, (Object)false)).setNameKey("block.ftbquests.screen.input_only");
        ((ItemStackConfig)cg.add("input_icon", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getInputModeIcon(), this::setInputModeIcon, (Object)ItemStack.EMPTY)).setNameKey("block.ftbquests.screen.input_mode_icon");
        return cg0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSuitableTask(TeamData data, QuestObjectBase o) {
        if (!(o instanceof Task)) return false;
        Task t = (Task)o;
        if (!data.getCanEdit(FTBQuestsClient.getClientPlayer())) {
            if (!data.canStartTasks(t.getQuest())) return false;
        }
        if (!t.consumesResources()) return false;
        return true;
    }

    public float[] getFakeTextureUV() {
        if (this.fakeTextureUV == null) {
            Item item;
            if (!this.skin.isEmpty() && (item = this.skin.getItem()) instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                BlockState state = bi.getBlock().defaultBlockState();
                Direction facing = (Direction)this.getBlockState().getValue((Property)TaskScreenBlock.FACING);
                if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
                } else if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
                }
                this.fakeTextureUV = FTBQuestsClient.getTextureUV(state, facing);
            } else {
                this.fakeTextureUV = new float[0];
            }
        }
        return this.fakeTextureUV;
    }
}

