/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.ftb.mods.ftblibrary.icon.AtlasSpriteIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.RenderUtil;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.EnergyTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class TaskScreenRenderer
implements BlockEntityRenderer<TaskScreenBlockEntity> {
    public static final ResourceLocation INPUT_ONLY_TEXTURE = new ResourceLocation("ftbquests", "tasks/input_only");
    public static final ResourceLocation TANK_TEXTURE = new ResourceLocation("ftbquests", "tasks/tank");
    public static final ResourceLocation FE_ENERGY_EMPTY_TEXTURE = new ResourceLocation("ftbquests", "tasks/fe_empty");
    public static final ResourceLocation FE_ENERGY_FULL_TEXTURE = new ResourceLocation("ftbquests", "tasks/fe_full");
    public static final ResourceLocation TR_ENERGY_EMPTY_TEXTURE = new ResourceLocation("ftbquests", "tasks/ic2_empty");
    public static final ResourceLocation TR_ENERGY_FULL_TEXTURE = new ResourceLocation("ftbquests", "tasks/ic2_full");
    private final BlockEntityRendererProvider.Context context;

    public TaskScreenRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public int getViewDistance() {
        return 64;
    }

    public boolean shouldRender(TaskScreenBlockEntity blockEntity, Vec3 vec3) {
        return super.shouldRender((BlockEntity)blockEntity, vec3);
    }

    public void render(TaskScreenBlockEntity taskScreen, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay) {
        Block block;
        if (!ClientQuestFile.exists() || !((block = taskScreen.getBlockState().getBlock()) instanceof TaskScreenBlock)) {
            return;
        }
        TaskScreenBlock taskScreenBlock = (TaskScreenBlock)block;
        TeamData data = ClientQuestFile.INSTANCE.getNullableTeamData(taskScreen.getTeamId());
        Task task = taskScreen.getTask();
        if (task == null || data == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        float rotation = ((Direction)taskScreen.getBlockState().getValue((Property)WallSignBlock.FACING)).toYRot() + 180.0f;
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.translate(-0.5, -0.5, -0.5);
        int size = taskScreenBlock.getSize() / 2;
        poseStack.translate((float)(-size), (float)(-size) * 2.0f, -0.02f);
        poseStack.scale((float)size * 2.0f + 1.0f, (float)size * 2.0f + 1.0f, 1.0f);
        Font font = this.context.getFont();
        double iconY = 0.5;
        MutableComponent top1 = taskScreen.isInputOnly() ? Component.empty() : task.getQuest().getTitle();
        MutableComponent top2 = taskScreen.isInputOnly() ? Component.empty() : task.getTitle();
        this.drawString(taskScreen, font, multiBufferSource, poseStack, (Component)top1, 0.02, 0.15);
        if (!top2.equals(Component.empty())) {
            this.drawString(taskScreen, font, multiBufferSource, poseStack, (Component)top2, 0.17, 0.07);
            iconY = 0.54;
        }
        if (!taskScreen.isInputOnly() && !task.hideProgressNumbers()) {
            long progress = data.getProgress(task);
            ChatFormatting col = progress == 0L ? ChatFormatting.GOLD : (progress < task.getMaxProgress() ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
            MutableComponent txt = Component.literal((String)(task.formatProgress(data, progress) + " / " + task.formatMaxProgress())).withStyle(col);
            this.drawString(taskScreen, font, multiBufferSource, poseStack, (Component)txt, 0.83, 0.15);
        }
        poseStack.pushPose();
        poseStack.translate(0.5, iconY, -0.01);
        poseStack.scale(taskScreen.isInputOnly() ? 0.5f : 0.45f, taskScreen.isInputOnly() ? 0.5f : 0.45f, 0.2f * (float)size);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        if (taskScreen.isInputOnly() && !taskScreen.getInputModeIcon().isEmpty()) {
            this.drawTaskIcon(taskScreen, data, ItemIcon.getItemIcon((ItemStack)taskScreen.getInputModeIcon()), poseStack, multiBufferSource);
        } else {
            this.drawTaskIcon(taskScreen, data, task.getIcon(), poseStack, multiBufferSource);
        }
        poseStack.popPose();
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.text((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        float[] f = taskScreen.getFakeTextureUV();
        if (f != null && f.length == 4) {
            poseStack.pushPose();
            poseStack.scale(0.0625f, 0.0625f, 0.0625f);
            poseStack.translate(0.0f, 0.0f, 0.01f);
            RenderUtil.create(poseStack, vertexConsumer, 0.0f, 0.0f).withUV(f[0], f[1], f[2], f[3]).draw();
            poseStack.popPose();
        }
        if (taskScreen.isInputOnly() && FTBQuestsClientEventHandler.inputOnlySprite != null) {
            TextureAtlasSprite s = FTBQuestsClientEventHandler.inputOnlySprite;
            poseStack.pushPose();
            poseStack.scale(0.0625f, 0.0625f, 0.0625f);
            RenderUtil.create(poseStack, vertexConsumer, 0.0f, 0.0f).withUV(s.getU0(), s.getV0(), s.getU1(), s.getV1()).draw();
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    /*
     * Unable to fully structure code
     */
    private void drawTaskIcon(TaskScreenBlockEntity taskScreen, TeamData data, Icon icon, PoseStack poseStack, MultiBufferSource buffer) {
        vertexConsumer = buffer.getBuffer(RenderType.text((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        task = taskScreen.getTask();
        progress = data.getProgress(task);
        poseStack.pushPose();
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        if (icon instanceof IconAnimation) {
            anim = (IconAnimation)icon;
            icon = (Icon)anim.list.get((int)(System.currentTimeMillis() / 1000L % (long)anim.list.size()));
        }
        if (!(task instanceof FluidTask) || !((var15_10 = (fluidTask = (FluidTask)task).getIcon()) instanceof AtlasSpriteIcon)) ** GOTO lbl-1000
        as = (AtlasSpriteIcon)var15_10;
        if (FTBQuestsClientEventHandler.tankSprite != null) {
            sprite = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(as.getId());
            if (progress > 0L) {
                heightInterpolated = 16.0f * (float)((double)progress / (double)task.getMaxProgress());
                RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withColor(FluidStackHooks.getColor((Fluid)fluidTask.getFluid()) | -16777216).withSize(16.0f, heightInterpolated).withUV(sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV(heightInterpolated)).draw();
            }
            s = FTBQuestsClientEventHandler.tankSprite;
            poseStack.translate(0.0f, 0.0f, -0.05f);
            RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withUV(s.getU0(), s.getV0(), s.getU1(), s.getV1()).draw();
        } else if (task instanceof EnergyTask) {
            energyTask = (EnergyTask)task;
            empty = energyTask.getClientData().getEmptyTexture();
            full = energyTask.getClientData().getFullTexture();
            RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withUV(empty.getU0(), empty.getV0(), empty.getU1(), empty.getV1()).draw();
            if (progress > 0L) {
                heightInterpolated = 16.0f * (float)((double)progress / (double)task.getMaxProgress());
                poseStack.translate(0.0f, 0.0f, -0.05f);
                RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withSize(16.0f, heightInterpolated).withUV(full.getU0(), full.getV0(), full.getU1(), full.getV(heightInterpolated)).draw();
            }
        } else if (icon instanceof ItemIcon) {
            itemIcon = (ItemIcon)icon;
            poseStack.scale(16.0f, 16.0f, 16.0f);
            Minecraft.getInstance().getItemRenderer().renderStatic(itemIcon.getStack(), ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, buffer, (Level)Minecraft.getInstance().level, 0);
        } else if (icon instanceof AtlasSpriteIcon) {
            spriteIcon = (AtlasSpriteIcon)icon;
            sprite = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(spriteIcon.getId());
            RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withUV(sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1()).draw();
        }
        poseStack.popPose();
    }

    private void drawString(TaskScreenBlockEntity taskScreen, Font font, MultiBufferSource bufferSource, PoseStack poseStack, Component text, double y, double size) {
        if (!text.equals(Component.empty())) {
            poseStack.pushPose();
            poseStack.translate(0.5, y, 0.0);
            int len = font.width((FormattedText)text);
            float scale = (float)(size / 9.0);
            double width = (float)len * scale;
            if (width > 1.0) {
                scale = (float)((double)scale / width);
                width = 1.0;
            }
            if (width > 0.9) {
                scale = (float)((double)scale * 0.9);
            }
            poseStack.scale(scale, scale, 1.0f);
            Matrix4f posMat = poseStack.last().pose();
            font.drawInBatch(text, (float)(-len) / 2.0f, 0.0f, -2565928, taskScreen.isTextShadow(), posMat, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            poseStack.popPose();
        }
    }
}

