/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.item_filtering;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.api.event.CustomFilterDisplayItemsEvent;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DisplayStacksCache {
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Object2ObjectLinkedOpenHashMap<CacheKey, List<ItemStack>> cache = new Object2ObjectLinkedOpenHashMap(1024);
    private static List<ItemStack> extraCache = null;

    @NotNull
    public static List<ItemStack> getCachedDisplayStacks(ItemStack filterStack, ItemFilterAdapter adapter) {
        CacheKey key = CacheKey.of(filterStack);
        List<ItemStack> result = (List<ItemStack>)cache.getAndMoveToFirst((Object)key);
        if (result == null) {
            result = DisplayStacksCache.computeMatchingStacks(adapter.getMatcher(filterStack));
            cache.put((Object)key, result);
            if (cache.size() >= 1024) {
                cache.removeLast();
            }
        }
        return result;
    }

    private static List<ItemStack> computeMatchingStacks(ItemFilterAdapter.Matcher matcher) {
        if (CreativeModeTabs.searchTab().getSearchTabDisplayItems().isEmpty()) {
            FTBQuestsClient.registryAccess().ifPresent(ra -> CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)FeatureFlags.DEFAULT_FLAGS, (boolean)true, (HolderLookup.Provider)ra));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        CreativeModeTabs.searchTab().getSearchTabDisplayItems().stream().filter(matcher).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        DisplayStacksCache.getExtraDisplayCache().stream().filter(matcher).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void clear() {
        cache.clear();
        extraCache = null;
    }

    @NotNull
    private static List<ItemStack> getExtraDisplayCache() {
        if (extraCache == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            ((Consumer)CustomFilterDisplayItemsEvent.ADD_ITEMSTACK.invoker()).accept(new CustomFilterDisplayItemsEvent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)));
            extraCache = builder.build();
        }
        return extraCache;
    }

    private record CacheKey(int key) {
        static CacheKey of(ItemStack filterStack) {
            return new CacheKey(Objects.hash(BuiltInRegistries.ITEM.getId((Object)filterStack.getItem()), filterStack.hasTag() ? filterStack.getTag().hashCode() : 0));
        }
    }
}

