/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.item;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MissingItem
extends Item {
    private static final ResourceLocation AIR = new ResourceLocation("minecraft:air");

    public static ItemStack readItem(CompoundTag tag) {
        if (tag.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ResourceLocation id = new ResourceLocation(tag.getString("id"));
        if (id.equals((Object)AIR)) {
            return ItemStack.EMPTY;
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(id);
        if (item == Items.AIR) {
            ItemStack stack = new ItemStack((ItemLike)FTBQuestsItems.MISSING_ITEM.get());
            stack.addTagElement("Item", (Tag)tag);
            return stack;
        }
        ItemStack stack = ItemStack.of((CompoundTag)tag);
        stack.setCount(tag.getInt("Count"));
        return stack;
    }

    public static CompoundTag writeItem(ItemStack stack) {
        if (stack.getItem() instanceof MissingItem && stack.hasTag() && stack.getTag().contains("Item")) {
            return stack.getTag().getCompound("Item");
        }
        SNBTCompoundTag tag = new SNBTCompoundTag();
        stack.save((CompoundTag)tag);
        tag.putInt("Count", stack.getCount());
        if (tag.size() == 2) {
            tag.singleLine();
        }
        return tag;
    }

    public MissingItem() {
        super(FTBQuestsItems.defaultProps().stacksTo(1));
    }

    public Component getName(ItemStack stack) {
        if (stack.hasTag() && stack.getTag().contains("Item")) {
            CompoundTag tag = stack.getTag().getCompound("Item");
            String id = tag.getString("id");
            int c = Math.max(1, tag.getInt("Count"));
            if (c == 1) {
                return Component.literal((String)id);
            }
            return Component.literal((String)(c + "x " + id));
        }
        return super.getName(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.hasTag() && stack.getTag().contains("Item")) {
            tooltip.add((Component)Component.translatable((String)"item.ftbquests.missing_item").withStyle(ChatFormatting.RED));
        }
    }
}

