/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.ChoiceReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ClaimChoiceRewardMessage
extends BaseC2SMessage {
    private final long id;
    private final int index;

    public ClaimChoiceRewardMessage(long i, int idx) {
        this.id = i;
        this.index = idx;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CLAIM_CHOICE_REWARD;
    }

    ClaimChoiceRewardMessage(FriendlyByteBuf buffer) {
        this.id = buffer.readLong();
        this.index = buffer.readVarInt();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.id);
        buffer.writeVarInt(this.index);
    }

    public void handle(NetworkManager.PacketContext context) {
        Reward reward = ServerQuestFile.INSTANCE.getReward(this.id);
        if (reward instanceof ChoiceReward) {
            ChoiceReward choiceReward = (ChoiceReward)reward;
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TeamData data = TeamData.get((Player)serverPlayer);
                RewardTable table = choiceReward.getTable();
                if (table != null && data.isCompleted(reward.getQuest()) && this.index >= 0 && this.index < table.getWeightedRewards().size()) {
                    table.getWeightedRewards().get(this.index).getReward().claim(serverPlayer, true);
                    data.claimReward(serverPlayer, reward, true);
                }
            }
        }
    }
}

