/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class CreateObjectMessage
extends BaseC2SMessage {
    private final long parent;
    private final QuestObjectType type;
    private final boolean openScreen;
    private final CompoundTag nbt;
    private final CompoundTag extra;

    CreateObjectMessage(FriendlyByteBuf buffer) {
        this.parent = buffer.readLong();
        this.type = (QuestObjectType)QuestObjectType.NAME_MAP.read(buffer);
        this.openScreen = buffer.readBoolean();
        this.nbt = buffer.readNbt();
        this.extra = buffer.readNbt();
    }

    public CreateObjectMessage(QuestObjectBase o, @Nullable CompoundTag e, boolean openScreen) {
        this.parent = o.getParentID();
        this.type = o.getObjectType();
        this.openScreen = openScreen;
        this.nbt = new CompoundTag();
        o.writeData(this.nbt);
        this.extra = e;
    }

    public CreateObjectMessage(QuestObjectBase o, @Nullable CompoundTag e) {
        this(o, e, true);
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CREATE_OBJECT;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.parent);
        QuestObjectType.NAME_MAP.write(buffer, (Object)this.type);
        buffer.writeBoolean(this.openScreen);
        buffer.writeNbt((Tag)this.nbt);
        buffer.writeNbt((Tag)this.extra);
    }

    public void handle(NetworkManager.PacketContext context) {
        Player player;
        if (NetUtils.canEdit(context) && (player = context.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            QuestObjectBase object = ServerQuestFile.INSTANCE.create(ServerQuestFile.INSTANCE.newID(), this.type, this.parent, this.extra == null ? new CompoundTag() : this.extra);
            object.readData(this.nbt);
            object.onCreated();
            object.getQuestFile().refreshIDMap();
            object.getQuestFile().clearCachedData();
            object.getQuestFile().markDirty();
            new CreateObjectResponseMessage(object, this.extra, this.openScreen ? sp.getUUID() : Util.NIL_UUID).sendToAll(sp.getServer());
        }
    }
}

