/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TaskScreenConfigResponse
extends BaseC2SMessage {
    private final BlockPos pos;
    private final CompoundTag payload;

    public TaskScreenConfigResponse(TaskScreenBlockEntity taskScreenBlockEntity) {
        this.pos = taskScreenBlockEntity.getBlockPos();
        this.payload = taskScreenBlockEntity.saveWithoutMetadata();
    }

    public TaskScreenConfigResponse(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.payload = buf.readNbt();
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.TASK_SCREEN_CONFIG_RESP;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeNbt((Tag)this.payload);
    }

    public void handle(NetworkManager.PacketContext context) {
        TaskScreenBlockEntity taskScreen;
        ServerPlayer serverPlayer;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (player = (serverPlayer = (ServerPlayer)player).level().getBlockEntity(this.pos)) instanceof TaskScreenBlockEntity && TaskScreenBlock.hasPermissionToEdit(serverPlayer, taskScreen = (TaskScreenBlockEntity)player)) {
            taskScreen.load(this.payload);
            serverPlayer.level().sendBlockUpdated(taskScreen.getBlockPos(), taskScreen.getBlockState(), taskScreen.getBlockState(), 3);
            taskScreen.setChanged();
        }
    }
}

