/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.loot;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.EditRewardTableScreen;
import dev.ftb.mods.ftbquests.client.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.RecipeModHelper;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class RewardTable
extends QuestObjectBase {
    private final BaseQuestFile file;
    private final List<WeightedReward> weightedRewards;
    private final Quest fakeQuest;
    private float emptyWeight;
    private int lootSize;
    private boolean hideTooltip;
    private boolean useTitle;
    private LootCrate lootCrate;
    private ResourceLocation lootTableId;
    private String filename;

    public RewardTable(long id, BaseQuestFile file) {
        this(id, file, "");
    }

    public RewardTable(long id, BaseQuestFile file, String filename) {
        super(id);
        this.file = file;
        this.filename = filename;
        this.weightedRewards = new ArrayList<WeightedReward>();
        this.fakeQuest = new Quest(-1L, new Chapter(-1L, this.file, file.getDefaultChapterGroup()));
        this.emptyWeight = 0.0f;
        this.lootSize = 1;
        this.hideTooltip = false;
        this.useTitle = false;
        this.lootCrate = null;
        this.lootTableId = null;
    }

    public Component getTitleOrElse(Component def) {
        return this.useTitle ? this.getTitle() : def;
    }

    public BaseQuestFile getFile() {
        return this.file;
    }

    public List<WeightedReward> getWeightedRewards() {
        return Collections.unmodifiableList(this.weightedRewards);
    }

    @Nullable
    public LootCrate getLootCrate() {
        return this.lootCrate;
    }

    public Quest getFakeQuest() {
        return this.fakeQuest;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.REWARD_TABLE;
    }

    @Override
    public BaseQuestFile getQuestFile() {
        return this.file;
    }

    public float getTotalWeight(boolean includeEmpty) {
        float initial = includeEmpty ? this.emptyWeight : 0.0f;
        return this.weightedRewards.stream().map(WeightedReward::getWeight).reduce(Float.valueOf(initial), Float::sum).floatValue();
    }

    public Collection<WeightedReward> generateWeightedRandomRewards(RandomSource random, int nAttempts, boolean includeEmpty) {
        float total = this.getTotalWeight(includeEmpty);
        if (total <= 0.0f) {
            return List.of();
        }
        List res = this.weightedRewards.stream().filter(reward -> reward.getWeight() == 0.0f).collect(Collectors.toCollection(ArrayList::new));
        nAttempts *= this.lootSize;
        block0: for (int i = 0; i < nAttempts; ++i) {
            float currentWeight;
            float threshold = random.nextFloat() * total;
            float f = currentWeight = includeEmpty ? this.emptyWeight : 0.0f;
            if (!(currentWeight < threshold)) continue;
            for (WeightedReward reward2 : this.weightedRewards) {
                if (!((currentWeight += reward2.getWeight()) >= threshold)) continue;
                res.add(reward2);
                continue block0;
            }
        }
        return res;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        if (this.emptyWeight > 0.0f) {
            nbt.putFloat("empty_weight", this.emptyWeight);
        }
        nbt.putInt("loot_size", this.lootSize);
        if (this.hideTooltip) {
            nbt.putBoolean("hide_tooltip", true);
        }
        if (this.useTitle) {
            nbt.putBoolean("use_title", true);
        }
        ListTag list = new ListTag();
        for (WeightedReward wr : this.weightedRewards) {
            SNBTCompoundTag nbt1 = new SNBTCompoundTag();
            wr.getReward().writeData((CompoundTag)nbt1);
            if (wr.getReward().getType() != RewardTypes.ITEM) {
                nbt1.putString("type", wr.getReward().getType().getTypeForNBT());
            } else if (nbt1.getTagType("item") == 8) {
                nbt1.singleLine();
            }
            if (wr.getWeight() != 1.0f) {
                nbt1.putFloat("weight", wr.getWeight());
            }
            list.add((Object)nbt1);
        }
        nbt.put("rewards", (Tag)list);
        if (this.lootCrate != null) {
            CompoundTag nbt1 = new CompoundTag();
            this.lootCrate.writeData(nbt1);
            nbt.put("loot_crate", (Tag)nbt1);
        }
        if (this.lootTableId != null) {
            nbt.putString("loot_table_id", this.lootTableId.toString());
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.emptyWeight = nbt.getFloat("empty_weight");
        this.lootSize = nbt.getInt("loot_size");
        this.hideTooltip = nbt.getBoolean("hide_tooltip");
        this.useTitle = nbt.getBoolean("use_title");
        this.weightedRewards.clear();
        ListTag list = nbt.getList("rewards", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbt1 = list.getCompound(i);
            Reward reward = RewardType.createReward(0L, this.fakeQuest, nbt1.getString("type"));
            if (reward == null) continue;
            reward.readData(nbt1);
            this.weightedRewards.add(new WeightedReward(reward, nbt1.contains("weight") ? nbt1.getFloat("weight") : 1.0f));
        }
        this.lootCrate = null;
        if (nbt.contains("loot_crate")) {
            this.lootCrate = new LootCrate(this, false);
            this.lootCrate.readData(nbt.getCompound("loot_crate"));
        }
        this.lootTableId = nbt.contains("loot_table_id") ? new ResourceLocation(nbt.getString("loot_table_id")) : null;
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.filename, Short.MAX_VALUE);
        buffer.writeFloat(this.emptyWeight);
        buffer.writeVarInt(this.lootSize);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.hideTooltip);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.useTitle);
        flags = Bits.setFlag((int)flags, (int)4, (this.lootCrate != null ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.lootTableId != null ? 1 : 0) != 0);
        buffer.writeVarInt(flags);
        buffer.writeVarInt(this.weightedRewards.size());
        for (WeightedReward wr : this.weightedRewards) {
            buffer.writeVarInt(wr.getReward().getType().intId);
            wr.getReward().writeNetData(buffer);
            buffer.writeFloat(wr.getWeight());
        }
        if (this.lootCrate != null) {
            this.lootCrate.writeNetData(buffer);
        }
        if (this.lootTableId != null) {
            buffer.writeResourceLocation(this.lootTableId);
        }
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.filename = buffer.readUtf(Short.MAX_VALUE);
        this.emptyWeight = buffer.readFloat();
        this.lootSize = buffer.readVarInt();
        int flags = buffer.readVarInt();
        this.hideTooltip = Bits.getFlag((int)flags, (int)1);
        this.useTitle = Bits.getFlag((int)flags, (int)2);
        boolean hasCrate = Bits.getFlag((int)flags, (int)4);
        boolean hasLootTableId = Bits.getFlag((int)flags, (int)8);
        this.weightedRewards.clear();
        int s = buffer.readVarInt();
        for (int i = 0; i < s; ++i) {
            RewardType type = this.file.getRewardType(buffer.readVarInt());
            Reward reward = type.createReward(0L, this.fakeQuest);
            reward.readNetData(buffer);
            float weight = buffer.readFloat();
            this.weightedRewards.add(new WeightedReward(reward, weight));
        }
        this.lootCrate = null;
        if (hasCrate) {
            this.lootCrate = new LootCrate(this, false);
            this.lootCrate.readNetData(buffer);
        }
        this.lootTableId = hasLootTableId ? buffer.readResourceLocation() : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addDouble("empty_weight", (double)this.emptyWeight, v -> {
            this.emptyWeight = v.floatValue();
        }, 0.0, 0.0, 2.147483647E9);
        config.addInt("loot_size", this.lootSize, v -> {
            this.lootSize = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addBool("hide_tooltip", this.hideTooltip, v -> {
            this.hideTooltip = v;
        }, false);
        config.addBool("use_title", this.useTitle, v -> {
            this.useTitle = v;
        }, false);
        if (this.lootCrate != null) {
            this.lootCrate.fillConfigGroup(config.getOrCreateSubgroup("loot_crate").setNameKey("item.ftbquests.lootcrate"));
        }
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.weightedRewards.forEach(reward -> reward.getReward().clearCachedData());
    }

    @Override
    public void deleteSelf() {
        this.file.removeRewardTable(this);
        super.deleteSelf();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null && gui.isViewingQuest()) {
            gui.refreshViewQuestPanel();
        } else {
            RewardTablesScreen gui1 = (RewardTablesScreen)((Object)ClientUtils.getCurrentGuiAs(RewardTablesScreen.class));
            if (gui1 != null) {
                gui1.refreshWidgets();
            }
        }
        this.file.updateLootCrates();
    }

    @Override
    public void editedFromGUIOnServer() {
        this.file.updateLootCrates();
    }

    @Override
    public void onCreated() {
        if (this.filename.isEmpty()) {
            this.filename = this.file.generateRewardTableName(RewardTable.titleToID(this.rawTitle).orElse(this.toString()));
        }
        this.file.addRewardTable(this);
    }

    public String getFilename() {
        if (this.filename.isEmpty()) {
            this.filename = RewardTable.getCodeString(this);
        }
        return this.filename;
    }

    @Override
    public Optional<String> getPath() {
        return Optional.of("reward_tables/" + this.getFilename() + ".snbt");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return this.weightedRewards.size() == 1 ? this.weightedRewards.get(0).getReward().getTitle() : Component.translatable((String)"ftbquests.reward_table");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.lootCrate != null) {
            return ItemIcon.getItemIcon((ItemStack)this.lootCrate.createStack());
        }
        if (this.weightedRewards.isEmpty()) {
            return Icons.DICE;
        }
        List icons = this.weightedRewards.stream().map(reward -> reward.getReward().getIcon()).collect(Collectors.toList());
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        new EditRewardTableScreen(gui, this, editedReward -> {
            new EditObjectMessage((QuestObjectBase)editedReward).sendToServer();
            this.clearCachedData();
        }).openGui();
    }

    public void addMouseOverText(TooltipList list, boolean includeWeight, boolean includeEmpty) {
        if (ClientQuestFile.INSTANCE.canEdit() || !this.hideTooltip) {
            float totalWeight = this.getTotalWeight(includeEmpty);
            if (includeWeight && includeEmpty && this.emptyWeight > 0.0f) {
                RewardTable.addItem(list, (Component)Component.translatable((String)"ftbquests.reward_table.nothing"), this.emptyWeight, totalWeight);
            }
            List sortedRewards = this.weightedRewards.stream().sorted().toList();
            BaseScreen gui = (BaseScreen)ClientUtils.getCurrentGuiAs(BaseScreen.class);
            int maxLines = gui == null ? 12 : (gui.height - 20) / (gui.getTheme().getFontHeight() + 2);
            int nRewards = sortedRewards.size();
            int start = nRewards > maxLines ? (int)(FTBQuestsClient.getClientLevel().getGameTime() / 10L % (long)nRewards) : 0;
            int nLines = Math.min(maxLines, nRewards);
            for (int idx = 0; idx < nLines; ++idx) {
                WeightedReward wr = (WeightedReward)sortedRewards.get((start + idx) % nRewards);
                if (includeWeight) {
                    RewardTable.addItem(list, wr.getReward().getTitle(), wr.getWeight(), totalWeight);
                    continue;
                }
                list.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append(wr.getReward().getTitle()));
            }
        }
    }

    private static void addItem(TooltipList list, Component text, float weight, float totalWeight) {
        list.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append(text).append((Component)Component.literal((String)(" [" + WeightedReward.chanceString(weight, totalWeight) + "]")).withStyle(ChatFormatting.DARK_GRAY)));
    }

    @Override
    public Set<RecipeModHelper.Components> componentsToRefresh() {
        return EnumSet.of(RecipeModHelper.Components.LOOT_CRATES);
    }

    public void addReward(WeightedReward weightedReward) {
        this.weightedRewards.add(weightedReward);
    }

    public void removeReward(WeightedReward weightedReward) {
        this.weightedRewards.remove(weightedReward);
    }

    public WeightedReward makeWeightedItemReward(ItemStack stack, float weight) {
        return new WeightedReward(new ItemReward(0L, this.fakeQuest, stack), weight);
    }

    public LootCrate toggleLootCrate() {
        this.lootCrate = this.lootCrate == null ? new LootCrate(this, true) : null;
        return this.lootCrate;
    }

    public boolean shouldShowTooltip() {
        return !this.hideTooltip;
    }
}

