/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class XPReward
extends Reward {
    private int xp;

    public XPReward(long id, Quest quest, int xp) {
        super(id, quest);
        this.xp = xp;
    }

    public XPReward(long id, Quest quest) {
        this(id, quest, 100);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.XP;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.putInt("xp", this.xp);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.xp = nbt.getInt("xp");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeVarInt(this.xp);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.xp = buffer.readVarInt();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("xp", this.xp, v -> {
            this.xp = v;
        }, 100, 1, Integer.MAX_VALUE).setNameKey("ftbquests.reward.ftbquests.xp");
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        player.giveExperiencePoints(this.xp);
        if (notify) {
            new DisplayRewardToastMessage(this.id, (Component)Component.translatable((String)"ftbquests.reward.ftbquests.xp").append(": ").append((Component)Component.literal((String)("+" + this.xp)).withStyle(ChatFormatting.GREEN)), (Icon)Color4I.empty()).sendTo(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"ftbquests.reward.ftbquests.xp").append(": ").append((Component)Component.literal((String)("+" + this.xp)).withStyle(ChatFormatting.GREEN));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return "+" + this.xp;
    }
}

