/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AdvancementTask
extends AbstractBooleanTask {
    private ResourceLocation advancement = new ResourceLocation("minecraft:story/root");
    private String criterion = "";

    public AdvancementTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.ADVANCEMENT;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.putString("advancement", this.advancement.toString());
        nbt.putString("criterion", this.criterion);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.advancement = new ResourceLocation(nbt.getString("advancement"));
        this.criterion = nbt.getString("criterion");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeResourceLocation(this.advancement);
        buffer.writeUtf(this.criterion, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.advancement = buffer.readResourceLocation();
        this.criterion = buffer.readUtf(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        if (KnownServerRegistries.client != null && !KnownServerRegistries.client.advancements.isEmpty()) {
            Map advancements = KnownServerRegistries.client.advancements;
            KnownServerRegistries.AdvancementInfo def = (KnownServerRegistries.AdvancementInfo)advancements.values().iterator().next();
            config.addEnum("advancement", (Object)this.advancement, v -> {
                this.advancement = v;
            }, NameMap.of((Object)def.id, (Object[])advancements.keySet().toArray(new ResourceLocation[0])).icon(id -> ItemIcon.getItemIcon((ItemStack)KnownServerRegistries.client.advancements.getOrDefault((Object)id, def).icon)).name(id -> KnownServerRegistries.client.advancements.getOrDefault((Object)id, def).name).create()).setNameKey("ftbquests.task.ftbquests.advancement");
        } else {
            config.addString("advancement", this.advancement.toString(), v -> {
                this.advancement = new ResourceLocation(v);
            }, "minecraft:story/root").setNameKey("ftbquests.task.ftbquests.advancement");
        }
        config.addString("criterion", this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && info.name.getContents() != PlainTextContents.EMPTY) {
            return Component.translatable((String)"ftbquests.task.ftbquests.advancement").append(": ").append((Component)Component.literal((String)"").append(info.name).withStyle(ChatFormatting.YELLOW));
        }
        return super.getAltTitle();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && !info.icon.isEmpty()) {
            return ItemIcon.getItemIcon((ItemStack)info.icon);
        }
        return super.getAltIcon();
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 5;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(this.advancement);
        if (advancementHolder == null) {
            return false;
        }
        AdvancementProgress progress = player.getAdvancements().getOrStartProgress(advancementHolder);
        if (this.criterion.isEmpty()) {
            return progress.isDone();
        }
        CriterionProgress criterionProgress = progress.getCriterion(this.criterion);
        return criterionProgress != null && criterionProgress.isDone();
    }
}

