/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FluidTask
extends Task {
    public static final ResourceLocation TANK_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/tank.png");
    private static final FluidStack WATER = FluidStack.create((Fluid)Fluids.WATER, (long)FluidStack.bucketAmount());
    private FluidStack fluidStack = FluidStack.create((Fluid)Fluids.WATER, (long)FluidStack.bucketAmount());

    public FluidTask(long id, Quest quest) {
        super(id, quest);
    }

    public Fluid getFluid() {
        return this.fluidStack.getFluid();
    }

    public FluidTask setFluid(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    public CompoundTag getFluidNBT() {
        return this.fluidStack.getTag();
    }

    @Override
    public TaskType getType() {
        return TaskTypes.FLUID;
    }

    @Override
    public long getMaxProgress() {
        return this.fluidStack.getAmount();
    }

    @Override
    public String formatMaxProgress() {
        return FluidTask.getVolumeString(this.fluidStack.getAmount());
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return FluidTask.getVolumeString((int)Math.min(Integer.MAX_VALUE, progress));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        super.addMouseOverText(list, teamData);
        if (FTBQuests.getRecipeModHelper().isRecipeModAvailable()) {
            list.blankLine();
            list.add((Component)Component.translatable((String)"ftbquests.task.ftbquests.item.shift_click_recipe").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        }
    }

    @Override
    public void onButtonClicked(Button button, boolean canClick) {
        if (FTBQuestsClient.isShiftPressed() && FTBQuests.getRecipeModHelper().isRecipeModAvailable()) {
            FTBQuests.getRecipeModHelper().showRecipes(this.fluidStack);
        } else {
            super.onButtonClicked(button, canClick);
        }
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        this.fluidStack.write(nbt);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.fluidStack = FluidStack.read((CompoundTag)nbt);
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        this.fluidStack.write(buffer);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.fluidStack = FluidStack.read((FriendlyByteBuf)buffer);
    }

    public static String getVolumeString(long a) {
        StringBuilder builder = new StringBuilder();
        if (a >= FluidStack.bucketAmount()) {
            if (a % FluidStack.bucketAmount() != 0L) {
                builder.append(StringUtils.formatDouble((double)((double)a / (double)FluidStack.bucketAmount())));
            } else {
                builder.append(a / FluidStack.bucketAmount());
            }
            builder.append(" B");
        } else {
            builder.append(a).append(" mB");
        }
        return builder.toString();
    }

    public MutableComponent getAltTitle() {
        return Component.literal((String)(FluidTask.getVolumeString(this.fluidStack.getAmount()) + " of ")).append(this.fluidStack.getName());
    }

    @Override
    public Icon getAltIcon() {
        return Icon.getIcon((ResourceLocation)ClientUtils.getStillTexture((FluidStack)this.fluidStack)).withTint(Color4I.rgb((int)ClientUtils.getFluidColor((FluidStack)this.fluidStack)));
    }

    @Override
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addFluidStack("fluid", this.fluidStack, v -> {
            this.fluidStack = v;
        }, WATER, false);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @Nullable
    public Optional<PositionedIngredient> getIngredient(Widget widget) {
        return PositionedIngredient.of((Object)this.fluidStack, (Widget)widget);
    }
}

