/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StatTask
extends Task {
    private ResourceLocation stat = Stats.MOB_KILLS;
    private int value = 1;

    public StatTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STAT;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String formatMaxProgress() {
        return Integer.toString(this.value);
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return Long.toUnsignedString(progress);
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.putString("stat", this.stat.toString());
        nbt.putInt("value", this.value);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.stat = new ResourceLocation(nbt.getString("stat"));
        this.value = nbt.getInt("value");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeResourceLocation(this.stat);
        buffer.writeVarInt(this.value);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stat = buffer.readResourceLocation();
        this.value = buffer.readVarInt();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        ArrayList list = new ArrayList();
        Stats.CUSTOM.iterator().forEachRemaining(s -> list.add((ResourceLocation)s.getValue()));
        config.addEnum("stat", (Object)this.stat, v -> {
            this.stat = v;
        }, NameMap.of((Object)Stats.MOB_KILLS, list).name(v -> Component.translatable((String)("stat." + v.getNamespace() + "." + v.getPath()))).create());
        config.addInt("value", this.value, v -> {
            this.value = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)("stat." + this.stat.getNamespace() + "." + this.stat.getPath()));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 3;
    }

    @Override
    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        int set;
        if (teamData.isCompleted(this) || !this.checkTaskSequence(teamData)) {
            return;
        }
        ResourceLocation statId = (ResourceLocation)BuiltInRegistries.CUSTOM_STAT.get(this.stat);
        if (statId == null) {
            statId = (ResourceLocation)BuiltInRegistries.CUSTOM_STAT.get(new ResourceLocation(this.stat.getPath()));
        }
        if (statId != null && (long)(set = Math.min(this.value, player.getStats().getValue(Stats.CUSTOM.get((Object)statId)))) > teamData.getProgress(this)) {
            teamData.setProgress(this, set);
        }
    }
}

