/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.DeferredInventoryDetection;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class FTBQuestsInventoryListener
implements ContainerListener {
    public final ServerPlayer player;

    public FTBQuestsInventoryListener(ServerPlayer p) {
        this.player = p;
    }

    public static void detect(ServerPlayer player, ItemStack craftedItem, long sourceTask) {
        List<Task> tasksToCheck;
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null || PlayerHooks.isFake((Player)player)) {
            return;
        }
        List<Task> list = tasksToCheck = craftedItem.isEmpty() ? file.getSubmitTasks() : file.getCraftingTasks();
        if (!tasksToCheck.isEmpty()) {
            FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
                TeamData data = file.getNullableTeamData(team.getId());
                if (data != null && !data.isLocked()) {
                    file.withPlayerContext(player, () -> {
                        for (Task task : tasksToCheck) {
                            if (task.id == sourceTask || !data.canStartTasks(task.getQuest())) continue;
                            task.submitTask(data, player, craftedItem);
                        }
                    });
                }
            });
        }
    }

    public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
    }

    public void slotChanged(AbstractContainerMenu menu, int index, ItemStack stack) {
        int slotNum;
        if (!stack.isEmpty() && menu.getSlot((int)index).container == this.player.getInventory() && (slotNum = menu.getSlot(index).getContainerSlot()) >= 0 && slotNum < this.player.getInventory().items.size()) {
            int delay = Mth.clamp((int)ServerQuestFile.INSTANCE.getDetectionDelay(), (int)0, (int)200);
            if (delay == 0) {
                FTBQuestsInventoryListener.detect(this.player, ItemStack.EMPTY, 0L);
            } else {
                DeferredInventoryDetection.scheduleInventoryCheck(this.player, delay);
            }
        }
    }
}

