/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.snad.blocks;

import com.robrit.snad.Snad;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.IPlantable;
import net.neoforged.neoforge.common.PlantType;

public class SuolSnadBlock
extends Block {
    public SuolSnadBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @ParametersAreNonnullByDefault
    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return plantable.getPlantType(world, pos) == PlantType.NETHER;
    }

    @ParametersAreNonnullByDefault
    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        this.tick(blockState, serverLevel, blockPos, random);
    }

    @ParametersAreNonnullByDefault
    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        SuolSnadBlock.acceleratedTick(serverLevel, blockPos, random);
    }

    public static void acceleratedTick(ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        BlockState blockAbove = serverLevel.getBlockState(blockPos.above());
        if (blockAbove.getBlock() instanceof IPlantable || blockAbove.is(Blocks.BAMBOO_SAPLING) || blockAbove.is(Blocks.BAMBOO)) {
            boolean isSameBlockType = true;
            int height = 1;
            while (isSameBlockType) {
                if (blockPos.above(height).getY() < serverLevel.getMaxBuildHeight()) {
                    BlockState nextBlock = serverLevel.getBlockState(blockPos.above(height));
                    if (nextBlock.is(blockAbove.getBlock())) {
                        for (int growthAttempts = 0; growthAttempts < Snad.config().getGrowthSpeed(); ++growthAttempts) {
                            nextBlock.randomTick(serverLevel, blockPos.above(height), random);
                        }
                        ++height;
                        continue;
                    }
                    isSameBlockType = false;
                    continue;
                }
                isSameBlockType = false;
            }
        }
    }
}

