/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.config.v3.serialization;

import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import fuzs.puzzleslib.impl.config.serialization.ConfigDataSetImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConfigDataSet<T>
extends Collection<T> {
    public static final String CONFIG_DESCRIPTION = "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern.";
    public static final String CONFIG_DESCRIPTION_NO_TAG = "Format for every entry is \"<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern.";

    public static <T> ConfigDataSet<T> from(ResourceKey<? extends Registry<? super T>> registryKey, String ... values) {
        return ConfigDataSet.from(KeyedValueProvider.registryEntries(registryKey), values);
    }

    public static <T> ConfigDataSet<T> from(ResourceKey<? extends Registry<? super T>> registryKey, List<String> values, Class<?> ... types) {
        return ConfigDataSet.from(KeyedValueProvider.registryEntries(registryKey), values, types);
    }

    public static <T> ConfigDataSet<T> from(ResourceKey<? extends Registry<? super T>> registryKey, List<String> values, BiPredicate<Integer, Object> filter, Class<?> ... types) {
        return ConfigDataSet.from(KeyedValueProvider.registryEntries(registryKey), values, filter, types);
    }

    public static <T> ConfigDataSet<T> from(KeyedValueProvider<T> valueProvider, String ... values) {
        return ConfigDataSet.from(valueProvider, Arrays.asList(values), new Class[0]);
    }

    public static <T> ConfigDataSet<T> from(KeyedValueProvider<T> valueProvider, List<String> values, Class<?> ... types) {
        return ConfigDataSet.from(valueProvider, values, (Integer index, Object value) -> true, types);
    }

    public static <T> ConfigDataSet<T> from(KeyedValueProvider<T> valueProvider, List<String> values, BiPredicate<Integer, Object> filter, Class<?> ... types) {
        return new ConfigDataSetImpl<T>(valueProvider, values, filter, types);
    }

    public Map<T, Object[]> toMap();

    public Set<T> toSet();

    @Nullable
    public Object[] get(T var1);

    public <V> V get(T var1, int var2);

    public <V> Optional<V> getOptional(T var1, int var2);

    @Override
    @ApiStatus.Internal
    public boolean add(T var1);

    @Override
    @ApiStatus.Internal
    public boolean remove(Object var1);

    @Override
    @ApiStatus.Internal
    public boolean addAll(@NotNull Collection<? extends T> var1);

    @Override
    @ApiStatus.Internal
    public boolean removeAll(@NotNull Collection<?> var1);

    @Override
    @ApiStatus.Internal
    public boolean retainAll(@NotNull Collection<?> var1);

    @Override
    @ApiStatus.Internal
    public void clear();
}

