/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@FunctionalInterface
public interface ContainerImpl
extends Container {
    public static ContainerImpl of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static ContainerImpl of(int size) {
        return ContainerImpl.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    public NonNullList<ItemStack> getItems();

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (ItemStack stack : this.getItems()) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.getContainerSize() ? (ItemStack)this.getItems().get(slot) : ItemStack.EMPTY;
    }

    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    default public void setItem(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.getContainerSize()) {
            this.getItems().set(slot, (Object)stack);
            if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
                stack.setCount(this.getMaxStackSize());
            }
            this.setChanged();
        }
    }

    default public void clearContent() {
        this.getItems().clear();
        this.setChanged();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }
}

