/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public interface PlayerSet {
    public void notify(Packet<?> var1);

    public static PlayerSet ofNone() {
        return packet -> {};
    }

    public static PlayerSet ofEntity(Entity entity) {
        PlayerSet playerSet;
        Objects.requireNonNull(entity, "entity is null");
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            playerSet = PlayerSet.ofPlayer(serverPlayer);
        } else {
            playerSet = PlayerSet.ofNone();
        }
        return playerSet;
    }

    public static PlayerSet ofPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return packet -> serverPlayer.connection.send(packet);
    }

    public static PlayerSet ofOthers(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return packet -> serverPlayer.getServer().getPlayerList().getPlayers().forEach(currentServerPlayer -> {
            if (currentServerPlayer != serverPlayer) {
                PlayerSet.ofPlayer(currentServerPlayer).notify(packet);
            }
        });
    }

    public static PlayerSet ofAll(MinecraftServer minecraftServer) {
        return packet -> minecraftServer.getPlayerList().getPlayers().forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).notify(packet));
    }

    public static PlayerSet inLevel(ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return packet -> {
            for (ServerPlayer serverPlayer : serverLevel.players()) {
                PlayerSet.ofPlayer(serverPlayer).notify(packet);
            }
        };
    }

    public static PlayerSet nearPosition(Vec3i position, ServerLevel serverLevel) {
        Objects.requireNonNull(position, "position is null");
        return PlayerSet.nearPosition(position.getX(), position.getY(), position.getZ(), serverLevel);
    }

    public static PlayerSet nearPosition(double posX, double posY, double posZ, ServerLevel serverLevel) {
        return PlayerSet.nearPosition(null, posX, posY, posZ, 64.0, serverLevel);
    }

    public static PlayerSet nearPosition(@Nullable ServerPlayer serverPlayer, double posX, double posY, double posZ, double distance, ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return packet -> serverLevel.getServer().getPlayerList().broadcast((Player)serverPlayer, posX, posY, posZ, distance, serverLevel.dimension(), packet);
    }

    public static PlayerSet nearBlockEntity(BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        Level level = blockEntity.getLevel();
        Objects.requireNonNull(level, "block entity level is null");
        Preconditions.checkState((!level.isClientSide ? 1 : 0) != 0, (Object)"block entity level is client level");
        return PlayerSet.nearPosition((Vec3i)blockEntity.getBlockPos(), (ServerLevel)level);
    }

    public static PlayerSet nearChunk(LevelChunk levelChunk) {
        Objects.requireNonNull(levelChunk, "chunk is null");
        Preconditions.checkState((!levelChunk.getLevel().isClientSide ? 1 : 0) != 0, (Object)"chunk level is client level");
        return PlayerSet.nearChunk((ServerLevel)levelChunk.getLevel(), levelChunk.getPos());
    }

    public static PlayerSet nearChunk(ServerLevel serverLevel, ChunkPos chunkPos) {
        Objects.requireNonNull(serverLevel, "server level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        return packet -> serverLevel.getChunkSource().chunkMap.getPlayers(chunkPos, false).forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).notify(packet));
    }

    public static PlayerSet nearEntity(Entity entity) {
        Objects.requireNonNull(entity, "entity is null");
        Preconditions.checkState((!entity.getCommandSenderWorld().isClientSide ? 1 : 0) != 0, (Object)"entity level is client level");
        return packet -> ((ServerLevel)entity.getCommandSenderWorld()).getChunkSource().broadcastAndSend(entity, packet);
    }

    public static PlayerSet nearPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return packet -> serverPlayer.serverLevel().getChunkSource().broadcast((Entity)serverPlayer, packet);
    }
}

