/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3.serialization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.network.serialization.RecordSerializer;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

public final class MessageSerializers {
    private static final Map<Class<?>, MessageSerializer<?>> SERIALIZERS = Collections.synchronizedMap(Maps.newIdentityHashMap());
    private static final Map<Class<?>, Function<Type[], MessageSerializer<?>>> CONTAINER_PROVIDERS = Collections.synchronizedMap(Maps.newLinkedHashMap());

    private MessageSerializers() {
    }

    public static <T> void registerSerializer(Class<T> type, FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader) {
        MessageSerializers.registerSerializer(type, new MessageSerializerImpl<T>(writer, reader));
    }

    public static <T> void registerSerializer(Class<? super T> type, ResourceKey<Registry<T>> resourceKey) {
        Registry registry = BuiltInRegistries.REGISTRY.containsKey(resourceKey.location()) ? (Registry)BuiltInRegistries.REGISTRY.get(resourceKey.location()) : null;
        Objects.requireNonNull(registry, "Registry for key %s not found".formatted(resourceKey.location()));
        MessageSerializers.registerSerializer(type, (friendlyByteBuf, t) -> friendlyByteBuf.writeVarInt(registry.getId(t)), friendlyByteBuf -> registry.byId(friendlyByteBuf.readVarInt()));
    }

    private static <T> void registerSerializer(Class<T> type, MessageSerializer<T> value) {
        if (SERIALIZERS.put(type, value) != null) {
            PuzzlesLib.LOGGER.warn("Overriding serializer registered for type {}", type);
        }
    }

    private static <T> void registerSerializer(Class<T> type, EntityDataSerializer<T> entityDataSerializer) {
        MessageSerializers.registerSerializer(type, (arg_0, arg_1) -> entityDataSerializer.write(arg_0, arg_1), arg_0 -> entityDataSerializer.read(arg_0));
    }

    public static <T> void registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
        if (CONTAINER_PROVIDERS.put(type, factory) != null) {
            PuzzlesLib.LOGGER.warn("Overriding collection provider registered for type {}", type);
        }
    }

    public static <T> MessageSerializer<T> findByType(Class<T> type) {
        MessageSerializer<Object> serializer = SERIALIZERS.get(type);
        if (serializer == null) {
            serializer = MessageSerializers.computeIfAbsent(type);
            SERIALIZERS.put(type, serializer);
        }
        return serializer;
    }

    private static <T, E extends Enum<E>> MessageSerializer<T> computeIfAbsent(Class<T> clazz) {
        if (Record.class.isAssignableFrom(clazz)) {
            return RecordSerializer.createRecordSerializer(clazz);
        }
        if (clazz.isArray()) {
            return MessageSerializers.createArraySerializer(clazz.getComponentType());
        }
        if (clazz.isEnum()) {
            return MessageSerializers.createEnumSerializer(clazz);
        }
        throw new RuntimeException("Missing serializer for type %s".formatted(clazz));
    }

    @ApiStatus.Internal
    public static MessageSerializer<?> findByGenericType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return MessageSerializers.findByType(clazz);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        for (Map.Entry<Class<?>, Function<Type[], MessageSerializer<?>>> entry : CONTAINER_PROVIDERS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue().apply(typeArguments);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return MessageSerializers.createCollectionSerializer(typeArguments, Sets::newLinkedHashSetWithExpectedSize);
        }
        return MessageSerializers.findByType(clazz);
    }

    private static <K, V> MessageSerializer<Map<K, V>> createMapSerializer(Type[] typeArguments) {
        MessageSerializer keySerializer = MessageSerializers.findByType((Class)typeArguments[0]);
        MessageSerializer valueSerializer = MessageSerializers.findByType((Class)typeArguments[1]);
        return new MessageSerializerImpl<Map<K, V>>((friendlyByteBuf, o) -> friendlyByteBuf.writeMap(o, keySerializer::write, valueSerializer::write), friendlyByteBuf -> friendlyByteBuf.readMap(keySerializer::read, valueSerializer::read));
    }

    private static <T, C extends Collection<T>> MessageSerializer<C> createCollectionSerializer(Type[] typeArguments, IntFunction<C> factory) {
        MessageSerializer serializer = MessageSerializers.findByType((Class)typeArguments[0]);
        return new MessageSerializerImpl((friendlyByteBuf, o) -> friendlyByteBuf.writeCollection(o, serializer::write), friendlyByteBuf -> friendlyByteBuf.readCollection(factory, serializer::read));
    }

    private static <T> MessageSerializer<Optional<T>> createOptionalSerializer(Type[] typeArguments) {
        MessageSerializer serializer = MessageSerializers.findByType((Class)typeArguments[0]);
        return new MessageSerializerImpl<Optional<T>>((friendlyByteBuf, o) -> friendlyByteBuf.writeOptional(o, serializer::write), friendlyByteBuf -> friendlyByteBuf.readOptional(serializer::read));
    }

    private static <L, R> MessageSerializer<Either<L, R>> createEitherSerializer(Type[] typeArguments) {
        MessageSerializer leftSerializer = MessageSerializers.findByType((Class)typeArguments[0]);
        MessageSerializer rightSerializer = MessageSerializers.findByType((Class)typeArguments[1]);
        return new MessageSerializerImpl<Either<L, R>>((friendlyByteBuf, o) -> friendlyByteBuf.writeEither(o, leftSerializer::write, rightSerializer::write), friendlyByteBuf -> friendlyByteBuf.readEither(leftSerializer::read, rightSerializer::read));
    }

    private static MessageSerializer<?> createArraySerializer(Class<?> clazz) {
        MessageSerializer<?> serializer = MessageSerializers.findByType(clazz);
        return new MessageSerializerImpl((buf, t) -> {
            int length = Array.getLength(t);
            buf.writeVarInt(length);
            for (int i = 0; i < length; ++i) {
                serializer.write((FriendlyByteBuf)buf, Array.get(t, i));
            }
        }, buf -> {
            int length = buf.readVarInt();
            Object array = Array.newInstance(clazz, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, serializer.read((FriendlyByteBuf)buf));
            }
            return array;
        });
    }

    private static <E extends Enum<E>> MessageSerializer<E> createEnumSerializer(Class<E> clazz) {
        return new MessageSerializerImpl(FriendlyByteBuf::writeEnum, buf -> buf.readEnum(clazz));
    }

    static {
        MessageSerializers.registerSerializer(Boolean.TYPE, FriendlyByteBuf::writeBoolean, FriendlyByteBuf::readBoolean);
        MessageSerializers.registerSerializer(Boolean.class, FriendlyByteBuf::writeBoolean, FriendlyByteBuf::readBoolean);
        MessageSerializers.registerSerializer(Integer.TYPE, FriendlyByteBuf::writeVarInt, FriendlyByteBuf::readVarInt);
        MessageSerializers.registerSerializer(Integer.class, FriendlyByteBuf::writeVarInt, FriendlyByteBuf::readVarInt);
        MessageSerializers.registerSerializer(Long.TYPE, FriendlyByteBuf::writeVarLong, FriendlyByteBuf::readVarLong);
        MessageSerializers.registerSerializer(Long.class, FriendlyByteBuf::writeVarLong, FriendlyByteBuf::readVarLong);
        MessageSerializers.registerSerializer(Float.TYPE, FriendlyByteBuf::writeFloat, FriendlyByteBuf::readFloat);
        MessageSerializers.registerSerializer(Float.class, FriendlyByteBuf::writeFloat, FriendlyByteBuf::readFloat);
        MessageSerializers.registerSerializer(Double.TYPE, FriendlyByteBuf::writeDouble, FriendlyByteBuf::readDouble);
        MessageSerializers.registerSerializer(Double.class, FriendlyByteBuf::writeDouble, FriendlyByteBuf::readDouble);
        MessageSerializers.registerSerializer(Byte.TYPE, FriendlyByteBuf::writeByte, FriendlyByteBuf::readByte);
        MessageSerializers.registerSerializer(Byte.class, FriendlyByteBuf::writeByte, FriendlyByteBuf::readByte);
        MessageSerializers.registerSerializer(Short.TYPE, FriendlyByteBuf::writeShort, FriendlyByteBuf::readShort);
        MessageSerializers.registerSerializer(Short.class, FriendlyByteBuf::writeShort, FriendlyByteBuf::readShort);
        MessageSerializers.registerSerializer(Character.TYPE, FriendlyByteBuf::writeChar, FriendlyByteBuf::readChar);
        MessageSerializers.registerSerializer(Character.class, FriendlyByteBuf::writeChar, FriendlyByteBuf::readChar);
        MessageSerializers.registerSerializer(String.class, EntityDataSerializers.STRING);
        MessageSerializers.registerSerializer(Date.class, FriendlyByteBuf::writeDate, FriendlyByteBuf::readDate);
        MessageSerializers.registerSerializer(Instant.class, FriendlyByteBuf::writeInstant, FriendlyByteBuf::readInstant);
        MessageSerializers.registerSerializer(UUID.class, FriendlyByteBuf::writeUUID, FriendlyByteBuf::readUUID);
        MessageSerializers.registerSerializer(Component.class, EntityDataSerializers.COMPONENT);
        MessageSerializers.registerSerializer(ItemStack.class, EntityDataSerializers.ITEM_STACK);
        MessageSerializers.registerSerializer(Rotations.class, EntityDataSerializers.ROTATIONS);
        MessageSerializers.registerSerializer(BlockPos.class, EntityDataSerializers.BLOCK_POS);
        MessageSerializers.registerSerializer(Direction.class, EntityDataSerializers.DIRECTION);
        MessageSerializers.registerSerializer(CompoundTag.class, EntityDataSerializers.COMPOUND_TAG);
        MessageSerializers.registerSerializer(ParticleOptions.class, EntityDataSerializers.PARTICLE);
        MessageSerializers.registerSerializer(VillagerData.class, EntityDataSerializers.VILLAGER_DATA);
        MessageSerializers.registerSerializer(Pose.class, EntityDataSerializers.POSE);
        MessageSerializers.registerSerializer(ChunkPos.class, FriendlyByteBuf::writeChunkPos, FriendlyByteBuf::readChunkPos);
        MessageSerializers.registerSerializer(ResourceLocation.class, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::readResourceLocation);
        MessageSerializers.registerSerializer(BlockHitResult.class, FriendlyByteBuf::writeBlockHitResult, FriendlyByteBuf::readBlockHitResult);
        MessageSerializers.registerSerializer(BitSet.class, FriendlyByteBuf::writeBitSet, FriendlyByteBuf::readBitSet);
        MessageSerializers.registerSerializer(GameProfile.class, FriendlyByteBuf::writeGameProfile, FriendlyByteBuf::readGameProfile);
        MessageSerializers.registerSerializer(Vec3.class, (friendlyByteBuf, vec3) -> {
            friendlyByteBuf.writeDouble(vec3.x());
            friendlyByteBuf.writeDouble(vec3.y());
            friendlyByteBuf.writeDouble(vec3.z());
        }, friendlyByteBuf -> new Vec3(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble()));
        MessageSerializers.registerSerializer(Vector3f.class, (friendlyByteBuf, vec3) -> {
            friendlyByteBuf.writeFloat(vec3.x());
            friendlyByteBuf.writeFloat(vec3.y());
            friendlyByteBuf.writeFloat(vec3.z());
        }, friendlyByteBuf -> new Vector3f(friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat()));
        MessageSerializers.registerSerializer(FriendlyByteBuf.class, (buf, other) -> {
            buf.writeVarInt(other.readableBytes());
            buf.writeBytes((ByteBuf)other);
            other.release();
        }, buf -> new FriendlyByteBuf(buf.readBytes(buf.readVarInt())));
        MessageSerializers.registerSerializer(SoundEvent.class, Registries.SOUND_EVENT);
        MessageSerializers.registerSerializer(Fluid.class, Registries.FLUID);
        MessageSerializers.registerSerializer(MobEffect.class, Registries.MOB_EFFECT);
        MessageSerializers.registerSerializer(Block.class, Registries.BLOCK);
        MessageSerializers.registerSerializer(Enchantment.class, Registries.ENCHANTMENT);
        MessageSerializers.registerSerializer(EntityType.class, Registries.ENTITY_TYPE);
        MessageSerializers.registerSerializer(Item.class, Registries.ITEM);
        MessageSerializers.registerSerializer(Potion.class, Registries.POTION);
        MessageSerializers.registerSerializer(ParticleType.class, Registries.PARTICLE_TYPE);
        MessageSerializers.registerSerializer(BlockEntityType.class, Registries.BLOCK_ENTITY_TYPE);
        MessageSerializers.registerSerializer(MenuType.class, Registries.MENU);
        MessageSerializers.registerSerializer(Attribute.class, Registries.ATTRIBUTE);
        MessageSerializers.registerSerializer(GameEvent.class, Registries.GAME_EVENT);
        MessageSerializers.registerSerializer(VillagerType.class, Registries.VILLAGER_TYPE);
        MessageSerializers.registerSerializer(VillagerProfession.class, Registries.VILLAGER_PROFESSION);
        MessageSerializers.registerSerializer(PoiType.class, Registries.POINT_OF_INTEREST_TYPE);
        MessageSerializers.registerContainerProvider(Map.class, MessageSerializers::createMapSerializer);
        MessageSerializers.registerContainerProvider(List.class, typeArguments -> MessageSerializers.createCollectionSerializer(typeArguments, Lists::newArrayListWithExpectedSize));
        MessageSerializers.registerContainerProvider(Optional.class, MessageSerializers::createOptionalSerializer);
        MessageSerializers.registerContainerProvider(Either.class, MessageSerializers::createEitherSerializer);
    }

    private record MessageSerializerImpl<T>(FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader) implements MessageSerializer<T>
    {
        @Override
        public void write(FriendlyByteBuf buf, T instance) {
            this.writer.accept((Object)buf, instance);
        }

        @Override
        public T read(FriendlyByteBuf buf) {
            return (T)this.reader.apply((Object)buf);
        }
    }
}

