/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.resources.v1;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModPackResources
implements PackResources {
    protected final String modLogoPath;
    private ResourceLocation id;
    private BuiltInMetadata metadata;
    private PackType packType;

    protected AbstractModPackResources() {
        this("mod_logo.png");
    }

    protected AbstractModPackResources(String modLogoPath) {
        Objects.requireNonNull(modLogoPath, "mod logo path is null");
        this.modLogoPath = modLogoPath;
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... elements) {
        String path = String.join((CharSequence)"/", elements);
        if ("pack.png".equals(path)) {
            return ModLoaderEnvironment.INSTANCE.getModContainer(this.getNamespace()).flatMap(container -> container.findResource(this.modLogoPath)).map(modResource -> () -> Files.newInputStream(modResource, new OpenOption[0])).orElse(null);
        }
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        return null;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
    }

    public Set<String> getNamespaces(PackType type) {
        Objects.requireNonNull(this.packType, "pack type is null");
        return this.packType == type ? Collections.singleton(this.getNamespace()) : Collections.emptySet();
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> deserializer) {
        Objects.requireNonNull(this.metadata, "metadata is null");
        return (T)this.metadata.get(deserializer);
    }

    public String packId() {
        return this.id.toString();
    }

    public boolean isBuiltin() {
        return true;
    }

    public void close() {
    }

    public final String getNamespace() {
        Objects.requireNonNull(this.id, "id is null");
        return this.id.getNamespace();
    }

    protected void setup() {
    }

    @ApiStatus.Internal
    static Pack buildPack(final PackType packType, final ResourceLocation identifier, final Supplier<AbstractModPackResources> factory, Component title, Component description, boolean required, Pack.Position position, boolean fixedPosition, boolean hidden, FeatureFlagSet features) {
        PackMetadataSection metadataSection = new PackMetadataSection(description, SharedConstants.getCurrentVersion().getPackVersion(packType), Optional.empty());
        final BuiltInMetadata metadata = BuiltInMetadata.of((MetadataSectionSerializer)PackMetadataSection.TYPE, (Object)metadataSection);
        Pack.Info info = CommonAbstractions.INSTANCE.createPackInfo(identifier, description, PackCompatibility.COMPATIBLE, features, hidden);
        return Pack.create((String)identifier.toString(), (Component)title, (boolean)required, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

            public PackResources openPrimary(String id) {
                AbstractModPackResources packResources = (AbstractModPackResources)factory.get();
                packResources.id = identifier;
                packResources.metadata = metadata;
                packResources.packType = packType;
                packResources.setup();
                return packResources;
            }

            public PackResources openFull(String id, Pack.Info info) {
                return this.openPrimary(id);
            }
        }, (Pack.Info)info, (Pack.Position)position, (boolean)fixedPosition, (PackSource)PackSource.BUILT_IN);
    }
}

