/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.impl.item.CopyTagShapedRecipe;
import fuzs.puzzleslib.impl.item.CopyTagShapelessRecipe;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public interface CopyTagRecipe {
    public static final String SHAPED_RECIPE_SERIALIZER_ID = "copy_tag_shaped_recipe";
    public static final String SHAPELESS_RECIPE_SERIALIZER_ID = "copy_tag_shapeless_recipe";

    public static RecipeSerializer<?> getModSerializer(String modId, String recipeSerializerId) {
        RecipeSerializer recipeSerializer = (RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.get(new ResourceLocation(modId, recipeSerializerId));
        if (recipeSerializer == null) {
            ContentRegistrationFlags.throwForFlag(ContentRegistrationFlags.COPY_TAG_RECIPES);
        }
        return recipeSerializer;
    }

    public static void registerSerializers(BiConsumer<String, Supplier<RecipeSerializer<?>>> registrar) {
        registrar.accept(SHAPED_RECIPE_SERIALIZER_ID, () -> new Serializer<ShapedRecipe, CopyTagShapedRecipe>((RecipeSerializer<ShapedRecipe>)new ShapedRecipe.Serializer(), CopyTagShapedRecipe::new));
        registrar.accept(SHAPELESS_RECIPE_SERIALIZER_ID, () -> new Serializer<ShapelessRecipe, CopyTagShapelessRecipe>((RecipeSerializer<ShapelessRecipe>)new ShapelessRecipe.Serializer(), CopyTagShapelessRecipe::new));
    }

    public Ingredient getCopyTagSource();

    default public void tryCopyTagToResult(ItemStack result, CraftingContainer craftingContainer) {
        for (int i = 0; i < craftingContainer.getContainerSize(); ++i) {
            ItemStack itemStack = craftingContainer.getItem(i);
            if (!this.getCopyTagSource().test(itemStack) || !itemStack.hasTag()) continue;
            result.setTag(itemStack.getTag().copy());
            return;
        }
    }

    public record Serializer<T extends CraftingRecipe, S extends CraftingRecipe & CopyTagRecipe>(RecipeSerializer<T> serializer, Factory<T, S> factory) implements RecipeSerializer<S>
    {
        public Codec<S> codec() {
            return RecordCodecBuilder.create(instance -> instance.group((App)((MapCodec.MapCodecCodec)this.serializer.codec()).codec().forGetter(arg -> arg), (App)Ingredient.CODEC.fieldOf("copy_from").forGetter(arg -> ((CopyTagRecipe)arg).getCopyTagSource())).apply((Applicative)instance, (craftingRecipe, ingredient) -> this.factory.apply(this, (CraftingRecipe)craftingRecipe, (Ingredient)ingredient)));
        }

        public S fromNetwork(FriendlyByteBuf buffer) {
            CraftingRecipe recipe = (CraftingRecipe)this.serializer.fromNetwork(buffer);
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            return this.factory.apply(this, recipe, ingredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, S recipe) {
            this.serializer.toNetwork(buffer, recipe);
            ((CopyTagRecipe)recipe).getCopyTagSource().toNetwork(buffer);
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends CraftingRecipe, S extends CraftingRecipe & CopyTagRecipe> {
        public S apply(RecipeSerializer<?> var1, T var2, Ingredient var3);
    }
}

