/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.config;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.config.ConfigDataHolderImpl;
import fuzs.puzzleslib.impl.config.ConfigHolderImpl;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public class NeoForgeConfigHolderImpl
extends ConfigHolderImpl {
    public NeoForgeConfigHolderImpl(String modId) {
        super(modId);
    }

    @Override
    protected <T extends ConfigCore> ConfigDataHolderImpl<T> client(Supplier<T> supplier) {
        return new NeoForgeConfigDataHolderImpl<T>(ModConfig.Type.CLIENT, "client", supplier);
    }

    @Override
    protected <T extends ConfigCore> ConfigDataHolderImpl<T> common(Supplier<T> supplier) {
        return new NeoForgeConfigDataHolderImpl<T>(ModConfig.Type.COMMON, "common", supplier);
    }

    @Override
    protected <T extends ConfigCore> ConfigDataHolderImpl<T> server(Supplier<T> supplier) {
        return new NeoForgeConfigDataHolderImpl<T>(ModConfig.Type.SERVER, supplier);
    }

    @Override
    protected void bake(ConfigDataHolderImpl<?> holder, String modId) {
        Optional<IEventBus> optional = NeoForgeModContainerHelper.getOptionalModEventBus(modId);
        optional.ifPresent(eventBus -> eventBus.addListener(evt -> ((NeoForgeConfigDataHolderImpl)holder).onModConfig(evt.getConfig(), true, "Loading")));
        optional.ifPresent(eventBus -> eventBus.addListener(evt -> ((NeoForgeConfigDataHolderImpl)holder).onModConfig(evt.getConfig(), true, "Reloading")));
        optional.ifPresent(eventBus -> eventBus.addListener(evt -> ((NeoForgeConfigDataHolderImpl)holder).onModConfig(evt.getConfig(), false, "Unloading")));
        ((NeoForgeConfigDataHolderImpl)holder).register(modId);
    }

    private static class NeoForgeConfigDataHolderImpl<T extends ConfigCore>
    extends ConfigDataHolderImpl<T> {
        private final ModConfig.Type configType;
        @Nullable
        private ModConfig modConfig;

        protected NeoForgeConfigDataHolderImpl(ModConfig.Type configType, Supplier<T> supplier) {
            this(configType, configType.extension(), supplier);
        }

        protected NeoForgeConfigDataHolderImpl(ModConfig.Type type, String configTypeName, Supplier<T> supplier) {
            super(configTypeName, supplier);
            this.configType = type;
        }

        @Override
        protected Either<Unit, String> findErrorMessage() {
            if (this.modConfig == null) {
                return Either.right((Object)"Mod config instance is missing");
            }
            if (this.modConfig.getConfigData() == null) {
                return Either.right((Object)"Config data is missing");
            }
            return super.findErrorMessage();
        }

        public void onModConfig(ModConfig modConfig, boolean isLoading, String eventType) {
            if (modConfig.getType() == this.configType && (this.modConfig == null || modConfig == this.modConfig)) {
                super.onModConfig(modConfig.getModId(), isLoading, eventType);
            }
        }

        public void register(String modId) {
            Objects.requireNonNull(this.config, "Attempting to register invalid config of type %s".formatted(this.configTypeName));
            if (this.modConfig != null) {
                throw new IllegalStateException(String.format("Config for type %s has already been registered", this.configTypeName));
            }
            ModContainer modContainer = NeoForgeModContainerHelper.getModContainer(modId);
            this.modConfig = new ModConfig(this.configType, (IConfigSpec)this.buildSpec(), modContainer, (String)this.fileName.apply(modId));
            modContainer.addConfig(this.modConfig);
            if (this.configType != ModConfig.Type.SERVER) {
                try {
                    Method method = ConfigTracker.class.getDeclaredMethod("openConfig", ModConfig.class, Path.class, Path.class);
                    method.setAccessible(true);
                    MethodHandles.lookup().unreflect(method).invoke(ConfigTracker.INSTANCE, this.modConfig, ModLoaderEnvironment.INSTANCE.getConfigDirectory(), null);
                }
                catch (Throwable throwable) {
                    PuzzlesLib.LOGGER.warn("Unable to load {} config for mod {} early", new Object[]{this.configTypeName, modId, throwable});
                }
            }
        }
    }
}

