/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.BiomeModificationContext;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import fuzs.puzzleslib.neoforge.impl.biome.BiomeLoadingContextNeoForge;
import fuzs.puzzleslib.neoforge.impl.biome.ClimateSettingsContextNeoForge;
import fuzs.puzzleslib.neoforge.impl.biome.GenerationSettingsContextNeoForge;
import fuzs.puzzleslib.neoforge.impl.biome.MobSpawnSettingsContextNeoForge;
import fuzs.puzzleslib.neoforge.impl.biome.SpecialEffectsContextNeoForge;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class NeoForgeBiomeLoadingHandler {
    private static final Map<BiomeModifier.Phase, BiomeLoadingPhase> BIOME_MODIFIER_PHASE_CONVERSIONS = Maps.immutableEnumMap((Map)new HashMap<BiomeModifier.Phase, BiomeLoadingPhase>(){
        {
            this.put(BiomeModifier.Phase.ADD, BiomeLoadingPhase.ADDITIONS);
            this.put(BiomeModifier.Phase.REMOVE, BiomeLoadingPhase.REMOVALS);
            this.put(BiomeModifier.Phase.MODIFY, BiomeLoadingPhase.MODIFICATIONS);
            this.put(BiomeModifier.Phase.AFTER_EVERYTHING, BiomeLoadingPhase.POST_PROCESSING);
        }
    });
    private static final String BIOME_MODIFICATIONS_NAME_KEY = "biome_modifications";
    private static final String BIOME_MODIFIERS_DATA_KEY = NeoForgeRegistries.Keys.BIOME_MODIFIERS.location().toString().replace(":", "/");
    private static final Function<String, ResourceLocation> BIOME_MODIFICATIONS_FILE_KEY = id -> new ResourceLocation(id, BIOME_MODIFIERS_DATA_KEY + "/" + id + ".json");
    private static final Function<ResourceLocation, String> BIOME_MODIFICATIONS_FILE_CONTENTS = id -> "{\"type\":\"" + id + "\"}";

    public static void register(String modId, IEventBus modEventBus, Multimap<BiomeLoadingPhase, BiomeModification> biomeModifications) {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)modId);
        deferredRegister.register(modEventBus);
        deferredRegister.register(BIOME_MODIFICATIONS_NAME_KEY, new BiomeModifierImpl(biomeModifications)::codec);
    }

    public static RepositorySource buildPack(final String modId) {
        final ResourceLocation id = new ResourceLocation(modId, BIOME_MODIFICATIONS_NAME_KEY);
        return PackResourcesHelper.buildServerPack(id, () -> new AbstractModPackResources(){

            @Override
            public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
                if (path.equals(BIOME_MODIFIERS_DATA_KEY)) {
                    resourceOutput.accept((Object)BIOME_MODIFICATIONS_FILE_KEY.apply(modId), () -> new ByteArrayInputStream(BIOME_MODIFICATIONS_FILE_CONTENTS.apply(id).getBytes(StandardCharsets.UTF_8)));
                }
            }
        }, false);
    }

    private record BiomeModifierImpl(Multimap<BiomeLoadingPhase, BiomeModification> biomeModifications, Codec<? extends BiomeModifier> codec) implements BiomeModifier
    {
        private BiomeModifierImpl(Multimap<BiomeLoadingPhase, BiomeModification> biomeModifications, @Nullable Codec<? extends BiomeModifier> codec) {
            this.biomeModifications = biomeModifications;
            this.codec = Codec.unit((Object)this);
        }

        public BiomeModifierImpl(Multimap<BiomeLoadingPhase, BiomeModification> biomeModifications) {
            this(biomeModifications, null);
        }

        private static BiomeModificationContext createBuilderBackedContext(ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            ClimateSettingsContextNeoForge climateSettings = new ClimateSettingsContextNeoForge(builder.getClimateSettings());
            SpecialEffectsContextNeoForge specialEffects = new SpecialEffectsContextNeoForge(builder.getSpecialEffects());
            GenerationSettingsContextNeoForge generationSettings = new GenerationSettingsContextNeoForge(builder.getGenerationSettings());
            MobSpawnSettingsContextNeoForge mobSpawnSettings = new MobSpawnSettingsContextNeoForge(builder.getMobSpawnSettings());
            return new BiomeModificationContext(climateSettings, specialEffects, generationSettings, mobSpawnSettings);
        }

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            BiomeLoadingPhase loadingPhase = BIOME_MODIFIER_PHASE_CONVERSIONS.get(phase);
            if (loadingPhase == null) {
                return;
            }
            Collection modifications = this.biomeModifications.get((Object)loadingPhase);
            if (modifications.isEmpty()) {
                return;
            }
            BiomeLoadingContextNeoForge filter = new BiomeLoadingContextNeoForge(biome);
            BiomeModificationContext context = BiomeModifierImpl.createBuilderBackedContext(builder);
            for (BiomeModification modification : modifications) {
                modification.tryApply(filter, context);
            }
        }
    }

    public record BiomeModification(Predicate<BiomeLoadingContext> selector, Consumer<BiomeModificationContext> modifier) {
        public void tryApply(BiomeLoadingContext filter, BiomeModificationContext context) {
            if (this.selector().test(filter)) {
                this.modifier().accept(context);
            }
        }
    }
}

