/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.item.crafting;

import fuzs.puzzleslib.api.item.v2.crafting.CombinedIngredients;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.common.crafting.IntersectionIngredient;
import net.neoforged.neoforge.common.crafting.NBTIngredient;

public final class NeoForgeCombinedIngredients
implements CombinedIngredients {
    @Override
    public Ingredient all(Ingredient ... ingredients) {
        Objects.requireNonNull(ingredients, "ingredients is null");
        for (Ingredient ingredient : ingredients) {
            Objects.requireNonNull(ingredient, "ingredient is null");
        }
        return IntersectionIngredient.of((Ingredient[])ingredients);
    }

    @Override
    public Ingredient any(Ingredient ... ingredients) {
        Objects.requireNonNull(ingredients, "ingredients is null");
        for (Ingredient ingredient : ingredients) {
            Objects.requireNonNull(ingredient, "ingredient is null");
        }
        return CompoundIngredient.of((Ingredient[])ingredients);
    }

    @Override
    public Ingredient difference(Ingredient ingredient, Ingredient subtracted) {
        Objects.requireNonNull(ingredient, "ingredient is null");
        Objects.requireNonNull(subtracted, "subtracted is null");
        return DifferenceIngredient.of((Ingredient)ingredient, (Ingredient)subtracted);
    }

    @Override
    public Ingredient nbt(ItemStack stack, boolean strict) {
        Objects.requireNonNull(stack, "stack is null");
        if (strict) {
            return NBTIngredient.of((boolean)true, (ItemStack)stack);
        }
        CompoundTag tag = stack.getTag();
        Objects.requireNonNull(tag, "tag is null");
        return NBTIngredient.of((boolean)false, (CompoundTag)tag, (ItemLike[])new ItemLike[]{stack.getItem()});
    }
}

