/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client.gui.elements;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class UIElement {
    protected static final Minecraft mc = Minecraft.getInstance();
    public Rectangle frame;
    @Nullable
    public String tooltip;
    protected final List<UIElement> children = new ArrayList<UIElement>();

    public static void render(GuiGraphics graphics, UIElement element, int mouseX, int mouseY) {
        UIElement.render(graphics, Collections.singletonList(element), mouseX, mouseY);
    }

    public static void render(GuiGraphics graphics, List<UIElement> elements, int mouseX, int mouseY) {
        elements.forEach(element -> element.render(graphics));
        elements.stream().flatMap(UIElement::getRecursiveChildren).filter(element -> element.hasTooltip() && element.frame.contains(mouseX, mouseY)).reduce((one, two) -> two).ifPresent(element -> element.renderTooltip(graphics, mouseX, mouseY));
    }

    public UIElement(Rectangle frame) {
        this.frame = frame;
    }

    protected void render(GuiGraphics graphics) {
        this.children.forEach(child -> child.render(graphics));
    }

    private Stream<UIElement> getRecursiveChildren() {
        return Stream.concat(Stream.of(this), this.children.stream().flatMap(UIElement::getRecursiveChildren));
    }

    protected boolean hasTooltip() {
        return this.tooltip != null;
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.tooltip == null) {
            return;
        }
        graphics.renderComponentTooltip(UIElement.mc.font, Collections.singletonList(Component.literal((String)this.tooltip)), mouseX, mouseY);
    }

    protected final void renderTooltip(GuiGraphics graphics, ItemStack itemStack, List<Component> tooltip, int mouseX, int mouseY) {
        assert (UIElement.mc.screen != null);
        graphics.renderComponentTooltip(UIElement.mc.font, tooltip, mouseX, mouseY, itemStack);
    }

    protected void calculateFrameFromChildren() {
        this.setMinX(this.children.stream().mapToInt(UIElement::getMinX).min().orElse(this.getMinX()));
        this.setWidth(this.children.stream().mapToInt(UIElement::getMaxX).max().orElse(this.getMaxX()) - this.getMinX());
        this.setMinY(this.children.stream().mapToInt(UIElement::getMinY).min().orElse(this.getMinY()));
        this.setHeight(this.children.stream().mapToInt(UIElement::getMaxY).max().orElse(this.getMaxY()) - this.getMinY());
    }

    public final int getCenterX() {
        return this.frame.x + this.frame.width / 2;
    }

    public final void setCenterX(int centerX) {
        this.frame.setLocation(centerX - this.frame.width / 2, this.frame.y);
    }

    public final int getCenterY() {
        return this.frame.y + this.frame.height / 2;
    }

    public final void setCenterY(int centerY) {
        this.frame.setLocation(this.frame.x, centerY - this.frame.height / 2);
    }

    public final int getMinX() {
        return this.frame.x;
    }

    public final void setMinX(int minX) {
        this.frame.setLocation(minX, this.frame.y);
    }

    public final int getMinY() {
        return this.frame.y;
    }

    public final void setMinY(int minY) {
        this.frame.setLocation(this.frame.x, minY);
    }

    public final int getMaxX() {
        return this.frame.x + this.frame.width;
    }

    public final void setMaxX(int maxX) {
        this.frame.setLocation(maxX - this.frame.width, this.frame.y);
    }

    public final int getMaxY() {
        return this.frame.y + this.frame.height;
    }

    public final void setMaxY(int maxY) {
        this.frame.setLocation(this.frame.x, maxY - this.frame.height);
    }

    public final int getWidth() {
        return this.frame.width;
    }

    public final void setWidth(int width) {
        this.frame.width = width;
    }

    public final int getHeight() {
        return this.frame.height;
    }

    public final void setHeight(int height) {
        this.frame.height = height;
    }

    public final void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }
}

