/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client.gui.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import team.creative.solonion.common.item.foodcontainer.FoodContainer;

public class FoodContainerScreen
extends AbstractContainerScreen<FoodContainer> {
    public FoodContainerScreen(FoodContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.drawBackground(graphics, new ResourceLocation("solonion", "textures/gui/inventory.png"));
        IItemHandler h = (IItemHandler)((FoodContainer)this.menu).containerItem.getCapability(Capabilities.ItemHandler.ITEM);
        if (h != null) {
            int slotsPerRow = h.getSlots();
            if (h.getSlots() > 9) {
                slotsPerRow = h.getSlots() / 2;
            }
            int xStart = (178 - slotsPerRow * 18) / 2;
            int yStart = 35;
            if (h.getSlots() > 9) {
                yStart = 29;
            }
            for (int i = 0; i < h.getSlots(); ++i) {
                int row = i / slotsPerRow;
                int col = i % slotsPerRow;
                int xPos = xStart - 1 + col * 18;
                int yPos = yStart - 1 + row * 18;
                this.drawSlot(graphics, xPos, yPos);
            }
        }
    }

    protected void drawBackground(GuiGraphics graphics, ResourceLocation gui) {
        int relX = (this.width - this.getXSize()) / 2;
        int relY = (this.height - this.getYSize()) / 2;
        graphics.blit(gui, relX, relY, 0, 0, this.getXSize(), this.getYSize());
    }

    protected void drawSlot(GuiGraphics graphics, int x, int y, ResourceLocation texture, int size) {
        graphics.blit(texture, this.getGuiLeft() + x, this.getGuiTop() + y, 0.0f, 0.0f, size, size, size, size);
    }

    protected void drawSlot(GuiGraphics graphics, int x, int y) {
        this.drawSlot(graphics, x, y, new ResourceLocation("solonion", "textures/gui/slot.png"), 18);
    }
}

