/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.premade.RegistryObjectConfig;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.ITextCollection;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;

public class Benefit<T> {
    public final RegistryObjectConfig<T> property;
    public double value;

    public static Benefit<Attribute> createAttribute(Attribute attribute, double value) {
        Registry reg = BuiltInRegistries.ATTRIBUTE;
        return new Benefit<Attribute>(new RegistryObjectConfig(reg, reg.getKey((Object)attribute)), value);
    }

    public static Benefit<Attribute> createAttribute(ResourceLocation location, double value) {
        return new Benefit<Attribute>(new RegistryObjectConfig(BuiltInRegistries.ATTRIBUTE, location), value);
    }

    public static Benefit<MobEffect> createMobEffect(MobEffect mob, double value) {
        Registry reg = BuiltInRegistries.MOB_EFFECT;
        return new Benefit<MobEffect>(new RegistryObjectConfig(reg, reg.getKey((Object)mob)), value);
    }

    public static Benefit<MobEffect> createMobEffect(ResourceLocation location, double value) {
        return new Benefit<MobEffect>(new RegistryObjectConfig(BuiltInRegistries.MOB_EFFECT, location), value);
    }

    public Benefit(RegistryObjectConfig<T> property, double value) {
        this.property = property;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Benefit) {
            Benefit benefit = (Benefit)obj;
            return this.property.equals(benefit.property) && this.value == benefit.value;
        }
        return false;
    }

    static {
        ConfigTypeConveration.registerTypeCreator(Benefit.class, () -> Benefit.createAttribute(Attributes.MAX_HEALTH, 2.0));
        ConfigTypeConveration.registerType(Benefit.class, (ConfigTypeConveration)new ConfigTypeConveration<Benefit>(){

            public Benefit readElement(Benefit defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    if (object.has("attribute")) {
                        return Benefit.createAttribute(new ResourceLocation(object.get("attribute").getAsString()), object.get("value").getAsDouble());
                    }
                    return Benefit.createMobEffect(new ResourceLocation(object.get("effect").getAsString()), object.get("value").getAsDouble());
                }
                return defaultValue;
            }

            public JsonElement writeElement(Benefit value, Benefit defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                JsonObject object = new JsonObject();
                if (value.property.registry == BuiltInRegistries.ATTRIBUTE) {
                    object.addProperty("attribute", value.property.location.toString());
                } else {
                    object.addProperty("effect", value.property.location.toString());
                }
                object.addProperty("value", (Number)value.value);
                return object;
            }

            @OnlyIn(value=Dist.CLIENT)
            public void createControls(final GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key, Class clazz) {
                parent.flow = GuiFlow.STACK_Y;
                parent.add((GuiControl)new GuiStateButton("state", 0, (ITextCollection)new TextListBuilder().addTranslated("config.solonion.", new String[]{"attribute", "effect"})){

                    public void raiseEvent(GuiEvent event) {
                        super.raiseEvent(event);
                        GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
                        Registry registry = this.getState() == 0 ? BuiltInRegistries.ATTRIBUTE : BuiltInRegistries.MOB_EFFECT;
                        box.setLines(new TextMapBuilder().addComponent((Iterable)registry.keySet(), value -> {
                            if (value.getNamespace().equals("minecraft")) {
                                return Component.literal((String)value.getPath());
                            }
                            return Component.literal((String)value.toString());
                        }));
                    }
                });
                parent.add((GuiControl)new GuiComboBoxMapped("elements", new TextMapBuilder()).setSearchbar(true));
                parent.add((GuiControl)new GuiTextfield("value").setFloatOnly().setDim(20, 6));
            }

            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(Benefit value, GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key) {
                GuiStateButton state = (GuiStateButton)parent.get("state");
                state.setState(value.property.registry == BuiltInRegistries.ATTRIBUTE ? 0 : 1);
                state.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)state));
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
                box.select((Object)value.property.location);
                GuiTextfield text = (GuiTextfield)parent.get("value");
                text.setText("" + value.value);
            }

            @OnlyIn(value=Dist.CLIENT)
            protected Benefit saveValue(GuiParent parent, IGuiConfigParent configParent, Class clazz, ConfigKey.ConfigKeyField key) {
                GuiStateButton state = (GuiStateButton)parent.get("state");
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
                GuiTextfield text = (GuiTextfield)parent.get("value");
                double value = text.parseDouble();
                if (state.getState() == 0) {
                    return Benefit.createAttribute((ResourceLocation)box.getSelected(), value);
                }
                return Benefit.createMobEffect((ResourceLocation)box.getSelected(), value);
            }

            public Benefit set(ConfigKey.ConfigKeyField key, Benefit value) {
                return value;
            }
        });
    }
}

