/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import org.jetbrains.annotations.UnknownNullability;
import team.creative.solonion.api.BenefitPlayerData;
import team.creative.solonion.common.benefit.BenefitStack;
import team.creative.solonion.common.mod.FirstAidManager;

public class BenefitPlayerDataImpl
implements BenefitPlayerData {
    private HashMap<Attribute, AttributeModifier> appliedAttributes;
    private List<MobEffect> appliedEffects;

    @Override
    public void onEffectRemove(MobEffectEvent.Remove event) {
        if (this.appliedEffects != null && this.appliedEffects.contains(event.getEffect())) {
            event.setCanceled(true);
        }
    }

    @Override
    public void updateStack(Player player, BenefitStack benefits) {
        if (this.appliedAttributes != null && !this.appliedAttributes.isEmpty()) {
            for (Map.Entry<Attribute, AttributeModifier> entry : this.appliedAttributes.entrySet()) {
                player.getAttribute(entry.getKey()).removeModifier(entry.getValue().getId());
            }
            this.appliedAttributes.clear();
        }
        if (this.appliedEffects != null && !this.appliedEffects.isEmpty()) {
            for (MobEffect mobEffect : this.appliedEffects) {
                player.removeEffect(mobEffect);
            }
            this.appliedEffects.clear();
        }
        if (benefits.isEmpty()) {
            return;
        }
        for (Object2DoubleMap.Entry entry : benefits.attributes()) {
            AttributeModifier modi = new AttributeModifier(((Attribute)entry.getKey()).getDescriptionId(), entry.getDoubleValue(), AttributeModifier.Operation.ADDITION);
            AttributeInstance att = player.getAttribute((Attribute)entry.getKey());
            if (att == null) continue;
            float oldMax = player.getMaxHealth();
            att.addPermanentModifier(modi);
            if (this.appliedAttributes == null) {
                this.appliedAttributes = new HashMap();
            }
            this.appliedAttributes.put((Attribute)entry.getKey(), modi);
            if (entry.getKey() != Attributes.MAX_HEALTH || FirstAidManager.INSTALLED) continue;
            float newHealth = player.getHealth() * player.getMaxHealth() / oldMax;
            player.setHealth(newHealth);
        }
        for (Object2IntMap.Entry entry : benefits.effects()) {
            MobEffectInstance in = new MobEffectInstance((MobEffect)entry.getKey(), -1, entry.getIntValue(), false, false);
            if (!player.addEffect(in)) continue;
            if (this.appliedEffects == null) {
                this.appliedEffects = new ArrayList<MobEffect>();
            }
            this.appliedEffects.add((MobEffect)entry.getKey());
        }
    }

    public @UnknownNullability CompoundTag serializeNBT() {
        ListTag list;
        CompoundTag nbt = new CompoundTag();
        if (this.appliedAttributes != null && !this.appliedAttributes.isEmpty()) {
            list = new ListTag();
            for (Map.Entry<Attribute, AttributeModifier> entry : this.appliedAttributes.entrySet()) {
                CompoundTag tag = new CompoundTag();
                tag.putString("att", BuiltInRegistries.ATTRIBUTE.getKey((Object)entry.getKey()).toString());
                tag.put("mod", (Tag)entry.getValue().save());
                list.add((Object)tag);
            }
            nbt.put("att", (Tag)list);
        }
        if (this.appliedEffects != null && !this.appliedEffects.isEmpty()) {
            list = new ListTag();
            for (MobEffect effect : this.appliedEffects) {
                list.add((Object)StringTag.valueOf((String)effect.builtInRegistryHolder().key().location().toString()));
            }
            nbt.put("eff", (Tag)list);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int i;
        if (this.appliedAttributes != null) {
            this.appliedAttributes.clear();
        }
        if (this.appliedEffects != null) {
            this.appliedEffects.clear();
        }
        if (nbt == null) {
            return;
        }
        ListTag list = nbt.getList("att", 10);
        if (!list.isEmpty()) {
            this.appliedAttributes = new HashMap();
            for (i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.getCompound(i);
                Attribute att = (Attribute)BuiltInRegistries.ATTRIBUTE.get(new ResourceLocation(tag.getString("att")));
                if (att == null) continue;
                this.appliedAttributes.put(att, AttributeModifier.load((CompoundTag)tag.getCompound("mod")));
            }
        }
        if (!(list = nbt.getList("eff", 8)).isEmpty()) {
            this.appliedEffects = new ArrayList<MobEffect>();
            for (i = 0; i < list.size(); ++i) {
                MobEffect mob = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(new ResourceLocation(list.getString(i)));
                if (mob == null) continue;
                this.appliedEffects.add(mob);
            }
        }
    }
}

