/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import team.creative.solonion.common.benefit.Benefit;

public class BenefitStack {
    private final Object2DoubleArrayMap<Attribute> attributes = new Object2DoubleArrayMap();
    private final Object2IntArrayMap<MobEffect> effects = new Object2IntArrayMap();

    public BenefitStack() {
    }

    public BenefitStack(Iterable<Benefit> benefits) {
        this.addAll(benefits);
    }

    public void add(Benefit benefit) {
        Object object = benefit.property.value;
        if (object instanceof Attribute) {
            Attribute a = (Attribute)object;
            this.attributes.compute((Object)a, (x, y) -> y != null ? Math.max(y, benefit.value) : benefit.value);
        } else {
            object = benefit.property.value;
            if (object instanceof MobEffect) {
                MobEffect m = (MobEffect)object;
                this.effects.compute((Object)m, (x, y) -> y != null ? Math.max(y, (int)benefit.value) : (int)benefit.value);
            }
        }
    }

    public void addAll(Iterable<Benefit> benefits) {
        for (Benefit benefit : benefits) {
            this.add(benefit);
        }
    }

    public Iterable<Object2DoubleMap.Entry<Attribute>> attributes() {
        return this.attributes.object2DoubleEntrySet();
    }

    public Iterable<Object2IntMap.Entry<MobEffect>> effects() {
        return this.effects.object2IntEntrySet();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty() && this.effects.isEmpty();
    }
}

