/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.event;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.solonion.api.FoodPlayerData;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.benefit.BenefitStack;
import team.creative.solonion.common.benefit.BenefitThreshold;
import team.creative.solonion.common.item.foodcontainer.FoodContainerItem;
import team.creative.solonion.common.network.FoodListMessage;

public class SOLOnionEvent {
    public void updatePlayerBenefits(Player player) {
        if (!SOLOnion.isActive(player) || !player.isAlive()) {
            return;
        }
        this.updateBenefits(player);
    }

    private void updateBenefits(Player player) {
        if (player.getCommandSenderWorld().isClientSide) {
            return;
        }
        FoodPlayerData foodList = SOLOnionAPI.getFoodCapability(player);
        if (foodList.trackCount() < SOLOnion.CONFIG.minFoodsToActivate) {
            return;
        }
        BenefitStack stack = new BenefitStack();
        double d = foodList.foodDiversity((LivingEntity)player);
        for (BenefitThreshold threshold : SOLOnion.CONFIG.benefits) {
            if (!(threshold.threshold <= d)) break;
            stack.add(threshold.benefit);
        }
        SOLOnionAPI.getBenefitCapability(player).updateStack(player, stack);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.updatePlayerBenefits(event.getEntity());
        this.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && SOLOnion.CONFIG.resetOnDeath) {
            return;
        }
        Player originalPlayer = event.getOriginal();
        FoodPlayerData original = SOLOnionAPI.getFoodCapability(originalPlayer);
        FoodPlayerData newInstance = SOLOnionAPI.getFoodCapability(event.getEntity());
        newInstance.deserializeNBT((Tag)((ListTag)original.serializeNBT()));
        this.updatePlayerBenefits(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.syncFoodList(event.getEntity());
    }

    public void syncFoodList(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        SOLOnion.NETWORK.sendToClient((CreativePacket)new FoodListMessage(SOLOnionAPI.getFoodCapability(player)), (ServerPlayer)player);
    }

    @SubscribeEvent
    public void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!SOLOnion.isActive(player)) {
            return;
        }
        ItemStack usedItem = event.getItem();
        if (usedItem.getFoodProperties((LivingEntity)player) == null && usedItem.getItem() != Items.CAKE) {
            return;
        }
        if (usedItem.getItem() instanceof FoodContainerItem) {
            return;
        }
        this.eat(usedItem, player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCakeBlockEaten(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        BlockState state = event.getLevel().getBlockState(event.getPos());
        Block clickedBlock = state.getBlock();
        Player player = event.getEntity();
        Item eatenItem = Items.CAKE;
        if (ModList.get().isLoaded("farmersdelight")) {
            eatenItem = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("farmersdelight:cake_slice"));
        }
        ItemStack eatenItemStack = new ItemStack((ItemLike)eatenItem);
        if (clickedBlock == Blocks.CAKE && player.canEat(false) && event.getHand() == InteractionHand.MAIN_HAND && !event.getLevel().isClientSide) {
            EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)eatenItemStack, (int)0, (ItemStack)ItemStack.EMPTY);
        }
    }

    public void eat(ItemStack food, Player player) {
        FoodPlayerData foodList = SOLOnionAPI.getFoodCapability(player);
        foodList.eat((LivingEntity)player, food);
        this.updatePlayerBenefits(player);
        this.syncFoodList(player);
    }

    @SubscribeEvent
    public void onEffectRemove(MobEffectEvent.Remove event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            SOLOnionAPI.getBenefitCapability(player).onEffectRemove(event);
        }
    }
}

