/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.javd.util;

import com.unrealdinnerbone.javd.JAVDRegistry;
import com.unrealdinnerbone.javd.block.PortalBlock;
import com.unrealdinnerbone.javd.block.PortalTileEntity;
import com.unrealdinnerbone.trenzalore.api.platform.Services;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class TelerportUtils {
    public static void teleport(Player playerEntity, ResourceKey<Level> toWorldKey, BlockPos blockPos, boolean spawnPlatform) {
        ServerLevel toWorld = playerEntity.getServer().getLevel(toWorldKey);
        if (toWorld != null) {
            TelerportUtils.findPortalLocation((Level)toWorld, blockPos).ifPresentOrElse(portalLocation -> {
                if (toWorld.getBlockState(portalLocation).isAir()) {
                    toWorld.setBlockAndUpdate(portalLocation, ((PortalBlock)((Object)((Object)JAVDRegistry.PORTAL_BLOCK.get()))).defaultBlockState());
                    Block block = BuiltInRegistries.BLOCK.getTag(JAVDRegistry.GENERATOR_BLOCKS).map(named -> named.getRandomElement(toWorld.getRandom())).filter(Optional::isPresent).map(Optional::get).map(Holder::value).orElse(Blocks.STONE);
                    int range = 3;
                    BlockPos.betweenClosedStream((BlockPos)portalLocation.offset(range, 0, range), (BlockPos)portalLocation.offset(-range, 0, -range)).forEach(blockPos1 -> {
                        if (toWorld.getBlockState(blockPos1).isAir()) {
                            toWorld.setBlockAndUpdate(blockPos1, block.defaultBlockState());
                        }
                    });
                }
                Vec3 portalLocationVec = new Vec3((double)portalLocation.getX() + 0.5, (double)(portalLocation.getY() + 1), (double)portalLocation.getZ() + 0.5);
                Services.PLATFORM.teleport((Entity)playerEntity, toWorld, new PortalInfo(portalLocationVec, playerEntity.getDeltaMovement(), playerEntity.getYRot(), playerEntity.getXRot()));
            }, () -> playerEntity.displayClientMessage((Component)Component.translatable((String)"javd.invalid.pos"), true));
        } else {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"javd.invalid.world", (Object[])new Object[]{toWorldKey.location().toString()}), true);
        }
    }

    private static Optional<BlockPos> findPortalLocation(Level worldTo, BlockPos fromPos) {
        if (worldTo.getBlockState(fromPos).getBlock() == JAVDRegistry.PORTAL_BLOCK.get() && TelerportUtils.isSafeSpawnLocation(worldTo, fromPos)) {
            return Optional.of(fromPos.above());
        }
        int range = 5;
        return Optional.ofNullable(ChunkPos.rangeClosed((ChunkPos)worldTo.getChunkAt(fromPos).getPos(), (int)range).map(chunkPos -> worldTo.getChunk(chunkPos.x, chunkPos.z).getBlockEntitiesPos()).flatMap(Collection::stream).toList().stream().filter(pos -> worldTo.getBlockEntity(pos) instanceof PortalTileEntity).findFirst().orElseGet(() -> {
            int y;
            int maxY;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
            int minY = worldTo.getMinBuildHeight();
            int start = minY + (maxY = worldTo.getMaxBuildHeight());
            if (start != 0) {
                start /= 2;
            }
            for (y = start - 1; y > minY; --y) {
                if (!TelerportUtils.forLocationAround(worldTo, mutableBlockPos, fromPos.getX(), fromPos.getZ(), y)) continue;
                return mutableBlockPos;
            }
            for (y = start; y < maxY; ++y) {
                if (!TelerportUtils.forLocationAround(worldTo, mutableBlockPos, fromPos.getX(), fromPos.getZ(), y)) continue;
                return mutableBlockPos;
            }
            return null;
        }));
    }

    private static boolean forLocationAround(Level levelTo, BlockPos.MutableBlockPos blockPos, int fromX, int fromZ, int y) {
        for (int x = fromX - 6; x < fromX + 6; ++x) {
            for (int z = fromZ - 6; z < fromZ + 6; ++z) {
                blockPos.set(x, y, z);
                if (!TelerportUtils.isSaveLocation(levelTo, blockPos)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSaveLocation(Level levelTo, BlockPos.MutableBlockPos blockPos) {
        BlockState blockState = levelTo.getBlockState((BlockPos)blockPos);
        return blockState.isAir() && TelerportUtils.isSafeSpawnLocation(levelTo, blockPos.above());
    }

    private static boolean isSafeSpawnLocation(Level world, BlockPos blockPos) {
        return world.isInWorldBounds(blockPos) && world.getBlockState(blockPos).isAir() && world.getBlockState(blockPos.above()).isAir();
    }
}

