/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester;

import appeng.api.AECapabilities;
import appeng.api.parts.PartModels;
import appeng.block.AEBaseBlockItem;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.requester.RequesterBlock;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.terminal.RequesterTerminalPart;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

public final class Registration {
    public static final BlockDefinition<RequesterBlock> REQUESTER_BLOCK = Registration.registerRequester();
    public static final ItemDefinition<PartItem<RequesterTerminalPart>> REQUESTER_TERMINAL = Registration.registerRequesterTerminal();
    private static final BlockEntityType<RequesterBlockEntity> REQUESTER_ENTITY = Registration.registerRequesterEntity();

    private Registration() {
    }

    private static BlockDefinition<RequesterBlock> registerRequester() {
        RequesterBlock block = new RequesterBlock();
        AEBaseBlockItem item = new AEBaseBlockItem((Block)block, new Item.Properties());
        return new BlockDefinition("", Utils.getRL("requester"), (Block)block, (BlockItem)item);
    }

    private static ItemDefinition<PartItem<RequesterTerminalPart>> registerRequesterTerminal() {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(RequesterTerminalPart.class));
        PartItem item = new PartItem(new Item.Properties(), RequesterTerminalPart.class, RequesterTerminalPart::new);
        return new ItemDefinition("", Utils.getRL("requester_terminal"), (Item)item);
    }

    private static BlockEntityType<RequesterBlockEntity> registerRequesterEntity() {
        AtomicReference<BlockEntityType> typeHolder = new AtomicReference<BlockEntityType>();
        BlockEntityType.BlockEntitySupplier supplier = (blockPos, blockState) -> new RequesterBlockEntity((BlockEntityType)typeHolder.get(), blockPos, blockState);
        BlockEntityType type = BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{REQUESTER_BLOCK.block()}).build(null);
        typeHolder.set(type);
        AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)REQUESTER_BLOCK.asItem());
        ((RequesterBlock)REQUESTER_BLOCK.block()).setBlockEntity(RequesterBlockEntity.class, type, null, null);
        return type;
    }

    static void registerContents(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.CREATIVE_MODE_TAB) {
            Tab.registerTab(event);
            return;
        }
        if (event.getRegistryKey() == Registries.BLOCK) {
            Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)REQUESTER_BLOCK.id(), (Object)((Object)((RequesterBlock)REQUESTER_BLOCK.block())));
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)REQUESTER_BLOCK.id(), (Object)((BlockItem)REQUESTER_BLOCK.asItem()));
            Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (ResourceLocation)REQUESTER_BLOCK.id(), REQUESTER_ENTITY);
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)REQUESTER_TERMINAL.id(), (Object)((PartItem)REQUESTER_TERMINAL.asItem()));
        }
    }

    static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, REQUESTER_ENTITY, (requester, ctx) -> requester);
    }

    public static final class Tab {
        public static final ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)Utils.getRL("tab"));
        private static final CreativeModeTab TAB = CreativeModeTab.builder().title((Component)Utils.translate("itemGroup", "tab", new Object[0])).icon(() -> REQUESTER_BLOCK.stack()).noScrollBar().build();

        private Tab() {
        }

        static void initContents(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == TAB_KEY) {
                event.accept(REQUESTER_BLOCK);
                event.accept(REQUESTER_TERMINAL);
            }
        }

        private static void registerTab(RegisterEvent registerEvent) {
            registerEvent.register(Registries.CREATIVE_MODE_TAB, TAB_KEY.location(), () -> TAB);
        }
    }
}

