/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client;

import appeng.api.inventories.InternalInventory;
import appeng.menu.slot.FakeSlot;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.client.abstraction.RequestDisplay;
import com.almostreliable.merequester.client.abstraction.RequesterReference;
import com.almostreliable.merequester.mixin.accessors.SlotMixin;
import com.almostreliable.merequester.network.DragAndDropPacket;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class RequestSlot
extends FakeSlot {
    private final RequestDisplay host;
    private final RequesterReference requesterReference;
    private final int slot;
    private boolean isLocked;

    public RequestSlot(RequestDisplay host, RequesterReference requesterReference, int slot, int x, int y) {
        super((InternalInventory)requesterReference.getRequests(), slot);
        this.host = host;
        this.requesterReference = requesterReference;
        this.slot = slot;
        Utils.cast((Object)this, SlotMixin.class).merequester$setX(x);
        Utils.cast((Object)this, SlotMixin.class).merequester$setY(y);
    }

    public void increase(ItemStack is) {
    }

    public void decrease(ItemStack is) {
    }

    public boolean hasItem() {
        return !this.isLocked && super.hasItem();
    }

    @Nullable
    public List<Component> getCustomTooltip(ItemStack carried) {
        if (this.isLocked) {
            return Collections.singletonList(Utils.translate("tooltip", "locked", new Object[0]).withStyle(ChatFormatting.RED));
        }
        List<Component> emptyingTooltip = this.host.getEmptyingTooltip(this, carried);
        if (emptyingTooltip == null) {
            return super.getCustomTooltip(carried);
        }
        return emptyingTooltip;
    }

    public final int getMaxStackSize() {
        return 0;
    }

    public RequesterReference getRequesterReference() {
        return this.requesterReference;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public void setFilterTo(ItemStack itemStack) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new DragAndDropPacket(this.getRequesterReference().getRequesterId(), this.getSlot(), itemStack)});
    }
}

