/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client.abstraction;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.EmptyingAction;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.core.network.NetworkHandler;
import appeng.core.network.ServerboundPacket;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import com.almostreliable.merequester.MERequester;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.client.RequestSlot;
import com.almostreliable.merequester.client.abstraction.RequestDisplay;
import com.almostreliable.merequester.client.abstraction.RequesterReference;
import com.almostreliable.merequester.client.widgets.RequestWidget;
import com.almostreliable.merequester.mixin.accessors.WidgetContainerMixin;
import com.almostreliable.merequester.requester.Requests;
import com.almostreliable.merequester.requester.abstraction.AbstractRequesterMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractRequesterScreen<M extends AbstractRequesterMenu>
extends AEBaseScreen<M>
implements RequestDisplay {
    protected static final int GUI_WIDTH = 195;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    protected static final int GUI_HEADER_HEIGHT = 19;
    protected static final int GUI_FOOTER_HEIGHT = 98;
    private static final int TEXT_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 156;
    protected static final int ROW_HEIGHT = 19;
    protected static final int MIN_ROW_COUNT = 3;
    private static final Rect2i HEADER_BBOX = new Rect2i(0, 0, 195, 19);
    private static final Rect2i TEXT_BBOX = new Rect2i(0, 19, 195, 19);
    private static final Rect2i REQUEST_BBOX = new Rect2i(0, 38, 195, 19);
    private final ResourceLocation texture;
    protected final ArrayList<Object> lines = new ArrayList();
    private final Scrollbar scrollbar;
    private final List<RequestWidget> requestWidgets = new ArrayList<RequestWidget>();
    protected boolean refreshList;
    protected int rowAmount;

    protected AbstractRequesterScreen(M menu, Inventory playerInventory, Component name, ScreenStyle style, ResourceLocation texture) {
        super(menu, playerInventory, name, style);
        this.texture = texture;
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.imageWidth = 195;
    }

    @Override
    public void addSubWidget(String id, AbstractWidget widget, Map<String, AbstractWidget> subWidgets) {
        if (widget.isFocused()) {
            widget.setFocused(false);
        }
        widget.setX(widget.getX() + this.leftPos);
        widget.setY(widget.getY() + this.topPos);
        subWidgets.put(id, widget);
        Utils.cast(this.widgets, WidgetContainerMixin.class).merequester$getWidgets().put(id, widget);
        this.addRenderableWidget((GuiEventListener)widget);
    }

    @Override
    @Nullable
    public Requests.Request getTargetRequest(int listIndex) {
        Requests.Request request;
        if (listIndex >= this.lines.size()) {
            return null;
        }
        Object lineElement = this.lines.get(this.scrollbar.getCurrentScroll() + listIndex);
        return lineElement instanceof Requests.Request ? (request = (Requests.Request)lineElement) : null;
    }

    @Override
    @Nullable
    public List<Component> getEmptyingTooltip(RequestSlot slot, ItemStack carried) {
        EmptyingAction emptyingAction = this.getEmptyingAction((Slot)slot, carried);
        if (emptyingAction == null) {
            return null;
        }
        return Tooltips.getEmptyingTooltip((ButtonToolTips)ButtonToolTips.SetAction, (ItemStack)carried, (EmptyingAction)emptyingAction);
    }

    public void updateFromMenu(boolean clearData, long requesterId, CompoundTag data) {
        if (clearData) {
            this.clear();
            this.refreshList();
            return;
        }
        String name = data.getString("unique_name");
        long sortBy = data.getLong("sort_by");
        Requests requests = this.getById(requesterId, name, sortBy).getRequests();
        for (int i = 0; i < requests.size(); ++i) {
            String requestIndex = String.valueOf(i);
            if (!data.contains(requestIndex)) continue;
            requests.get(i).deserializeNBT(data.getCompound(requestIndex));
        }
        if (this.refreshList) {
            this.refreshList();
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void init() {
        this.imageHeight = 117 + this.rowAmount * 19;
        this.requestWidgets.forEach(w -> w.preInit(Utils.cast(this.widgets, WidgetContainerMixin.class).merequester$getWidgets()));
        super.init();
        this.requestWidgets.clear();
        for (int i = 0; i < this.rowAmount; ++i) {
            RequestWidget requestWidget = new RequestWidget(this, i, 8, (i + 1) * 19, this.style);
            requestWidget.postInit();
            this.requestWidgets.add(requestWidget);
        }
        this.resetScrollbar();
    }

    @Nullable
    protected EmptyingAction getEmptyingAction(Slot slot, ItemStack carried) {
        if (slot instanceof RequestSlot) {
            RequestSlot requestSlot = (RequestSlot)slot;
            EmptyingAction emptyingAction = ContainerItemStrategies.getEmptyingAction((ItemStack)carried);
            if (emptyingAction == null) {
                return null;
            }
            ItemStack wrappedStack = GenericStack.wrapInItemStack((GenericStack)new GenericStack(emptyingAction.what(), 1L));
            if (!requestSlot.getInventory().isItemValid(requestSlot.getSlot(), wrappedStack)) {
                return null;
            }
            return emptyingAction;
        }
        return super.getEmptyingAction(slot, carried);
    }

    public void drawFG(GuiGraphics guiGraphics, int pX, int pY, int mX, int mY) {
        ((AbstractRequesterMenu)this.menu).slots.removeIf(RequestSlot.class::isInstance);
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        if (this.lines.isEmpty()) {
            String text = Utils.translateAsString("gui", "no_requesters");
            int textWidth = this.font.width(text);
            guiGraphics.drawString(this.font, text, (int)((float)(195 - textWidth) / 2.0f - 10.0f), 25, textColor, false);
            this.requestWidgets.forEach(RequestWidget::hide);
            return;
        }
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.rowAmount; ++i) {
            if (scrollLevel + i >= this.lines.size()) {
                this.requestWidgets.get(i).hide();
                continue;
            }
            Object lineElement = this.lines.get(scrollLevel + i);
            if (lineElement instanceof Requests.Request) {
                Requests.Request request = (Requests.Request)lineElement;
                ((AbstractRequesterMenu)this.menu).slots.add((Object)this.createSlot(i, request));
                this.requestWidgets.get(i).applyRequest(request);
                continue;
            }
            if (lineElement instanceof String) {
                String name;
                String text = name = (String)lineElement;
                int rows = this.getByName(name).size();
                if (rows > 1) {
                    text = String.format("%s (%s)", text, rows);
                }
                text = this.font.plainSubstrByWidth(text, 156, true);
                guiGraphics.drawString(this.font, text, 10, 25 + i * 19, textColor, false);
                this.requestWidgets.get(i).hide();
                continue;
            }
            MERequester.LOGGER.debug("Unknown line element: {}", lineElement);
        }
    }

    protected void slotClicked(@Nullable Slot slot, int slotIndex, int mouseButton, ClickType clickType) {
        if (!(slot instanceof RequestSlot)) {
            super.slotClicked(slot, slotIndex, mouseButton, clickType);
            return;
        }
        RequestSlot requestSlot = (RequestSlot)slot;
        if (requestSlot.isLocked()) {
            return;
        }
        if (mouseButton == 1 && this.getEmptyingAction(slot, ((AbstractRequesterMenu)this.menu).getCarried()) != null) {
            InventoryActionPacket packet = new InventoryActionPacket(InventoryAction.EMPTY_ITEM, requestSlot.getSlot(), requestSlot.getRequesterReference().getRequesterId());
            NetworkHandler.instance().sendToServer((ServerboundPacket)packet);
            return;
        }
        InventoryAction action = null;
        switch (clickType) {
            case PICKUP: {
                action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                break;
            }
            case QUICK_MOVE: {
                action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                break;
            }
            case CLONE: {
                if (!this.getPlayer().getAbilities().instabuild) break;
                action = InventoryAction.CREATIVE_DUPLICATE;
                break;
            }
        }
        if (action != null) {
            InventoryActionPacket packet = new InventoryActionPacket(action, requestSlot.getSlot(), requestSlot.getRequesterReference().getRequesterId());
            NetworkHandler.instance().sendToServer((ServerboundPacket)packet);
        }
    }

    public void drawBG(GuiGraphics guiGraphics, int pX, int pY, int mX, int mY, float partial) {
        this.blit(guiGraphics, pX, pY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = pY + 19;
        this.blit(guiGraphics, pX, currentY + this.rowAmount * 19, this.getFooterBounds());
        for (int i = 0; i < this.rowAmount; ++i) {
            boolean isRequestElement = false;
            if (scrollLevel + i < this.lines.size()) {
                Object lineElement = this.lines.get(scrollLevel + i);
                isRequestElement = lineElement instanceof Requests.Request;
            }
            this.blit(guiGraphics, pX, currentY, isRequestElement ? REQUEST_BBOX : TEXT_BBOX);
            currentY += 19;
        }
    }

    protected void resetScrollbar() {
        this.scrollbar.setHeight(this.rowAmount * 19 + 1);
        this.scrollbar.setRange(0, this.lines.size() - this.rowAmount, 2);
    }

    protected abstract void clear();

    protected abstract void refreshList();

    protected abstract Set<RequesterReference> getByName(String var1);

    protected abstract RequesterReference getById(long var1, String var3, long var4);

    private void blit(GuiGraphics guiGraphics, int pX, int pY, Rect2i srcRect) {
        guiGraphics.blit(this.texture, pX, pY, srcRect.getX(), srcRect.getY(), srcRect.getWidth(), srcRect.getHeight());
    }

    private RequestSlot createSlot(int index, Requests.Request request) {
        RequestSlot slot = new RequestSlot(this, (RequesterReference)request.getRequesterReference(), request.getIndex(), 27, (index + 1) * 19 + 1);
        slot.setHideAmount(true);
        slot.setLocked(request.getClientStatus().locksRequest());
        return slot;
    }

    protected abstract Rect2i getFooterBounds();
}

