/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client.widgets;

import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AECheckbox;
import appeng.client.gui.widgets.ITooltip;
import com.almostreliable.merequester.Utils;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class StateBox
extends AECheckbox
implements ITooltip {
    private static final int SIZE = 14;
    private static final Blitter BLITTER = Blitter.texture((ResourceLocation)Utils.getRL("textures/gui/state_box.png"), (int)28, (int)28);
    private static final Blitter UNCHECKED = BLITTER.copy().src(0, 0, 14, 14);
    private static final Blitter UNCHECKED_FOCUS = BLITTER.copy().src(14, 0, 14, 14);
    private static final Blitter CHECKED = BLITTER.copy().src(0, 14, 14, 14);
    private static final Blitter CHECKED_FOCUS = BLITTER.copy().src(14, 14, 14, 14);

    StateBox(int x, int y, ScreenStyle style, Runnable changeListener) {
        super(x + 2, y + 2, 14, 14, style, (Component)Component.empty());
        this.setChangeListener(changeListener);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mX, int mY, float partial) {
        Blitter icon = this.isFocused() || this.isMouseOver(mX, mY) ? (this.isSelected() ? CHECKED_FOCUS : UNCHECKED_FOCUS) : (this.isSelected() ? CHECKED : UNCHECKED);
        float opacity = this.isActive() ? 1.0f : 0.5f;
        icon.dest(this.getX(), this.getY()).opacity(opacity).blit(guiGraphics);
    }

    public List<Component> getTooltipMessage() {
        return List.of(Utils.translate("tooltip", "toggle", new Object[0]));
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), this.width, this.height);
    }

    public boolean isTooltipAreaVisible() {
        return this.visible;
    }
}

