/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client.widgets;

import appeng.client.gui.widgets.ITooltip;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.requester.status.RequestStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;

public class StatusDisplay
extends AbstractWidget
implements ITooltip {
    private static final int WIDTH = 118;
    private static final int HEIGHT = 2;
    private final BooleanSupplier isInactive;
    private RequestStatus status = RequestStatus.IDLE;

    StatusDisplay(int x, int y, BooleanSupplier isInactive) {
        super(x, y, 118, 2, (Component)Component.empty());
        this.isInactive = isInactive;
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mX, int mY, float partialTick) {
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, Utils.fillColorAlpha(this.getStatusColor()));
    }

    protected boolean isValidClickButton(int button) {
        return false;
    }

    private ChatFormatting getStatusColor(RequestStatus requestStatus) {
        return switch (requestStatus) {
            case RequestStatus.IDLE -> ChatFormatting.DARK_GREEN;
            case RequestStatus.MISSING -> ChatFormatting.RED;
            case RequestStatus.LINK -> ChatFormatting.YELLOW;
            case RequestStatus.EXPORT -> ChatFormatting.DARK_PURPLE;
            default -> throw new IllegalStateException("Impossible client state: " + requestStatus);
        };
    }

    public List<Component> getTooltipMessage() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Utils.translate("tooltip", "status", new Object[0]));
        if (Screen.hasShiftDown()) {
            tooltip.addAll(List.of(Component.literal((String)" "), Utils.translate("tooltip", RequestStatus.IDLE.toString().toLowerCase(), new Object[0]).withStyle(this.getStatusColor(RequestStatus.IDLE)), Utils.translate("tooltip", String.format("%s_desc", RequestStatus.IDLE.toString().toLowerCase()), new Object[0]), Component.literal((String)" "), Utils.translate("tooltip", RequestStatus.MISSING.toString().toLowerCase(), new Object[0]).withStyle(this.getStatusColor(RequestStatus.MISSING)), Utils.translate("tooltip", String.format("%s_desc", RequestStatus.MISSING.toString().toLowerCase()), new Object[0]), Component.literal((String)" "), Utils.translate("tooltip", RequestStatus.LINK.toString().toLowerCase(), new Object[0]).withStyle(this.getStatusColor(RequestStatus.LINK)), Utils.translate("tooltip", String.format("%s_desc", RequestStatus.LINK.toString().toLowerCase()), new Object[0]), Component.literal((String)" "), Utils.translate("tooltip", RequestStatus.EXPORT.toString().toLowerCase(), new Object[0]).withStyle(this.getStatusColor(RequestStatus.EXPORT)), Utils.translate("tooltip", String.format("%s_desc", RequestStatus.EXPORT.toString().toLowerCase()), new Object[0])));
        } else {
            Utils.addShiftInfoTooltip(tooltip);
        }
        return tooltip;
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), this.width, this.height);
    }

    public boolean isTooltipAreaVisible() {
        return this.visible;
    }

    private ChatFormatting getStatusColor() {
        if (this.isInactive.getAsBoolean()) {
            return ChatFormatting.DARK_GRAY;
        }
        return this.getStatusColor(this.status);
    }

    void setStatus(RequestStatus status) {
        this.status = status;
    }
}

