/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.network;

import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.network.Packet;
import com.almostreliable.merequester.requester.abstraction.AbstractRequesterMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public final class DragAndDropPacket
implements Packet {
    static final ResourceLocation ID = Utils.getRL("drag_and_drop");
    private final long requesterId;
    private final int requestIndex;
    private final ItemStack item;

    public DragAndDropPacket(long requesterId, int requestIndex, ItemStack item) {
        this.requesterId = requesterId;
        this.requestIndex = requestIndex;
        this.item = item;
    }

    public ResourceLocation id() {
        return ID;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.requesterId);
        buffer.writeVarInt(this.requestIndex);
        buffer.writeItem(this.item);
    }

    static DragAndDropPacket decode(FriendlyByteBuf buffer) {
        return new DragAndDropPacket(buffer.readLong(), buffer.readVarInt(), buffer.readItem());
    }

    @Override
    public void handle(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof AbstractRequesterMenu) {
                AbstractRequesterMenu requester = (AbstractRequesterMenu)abstractContainerMenu;
                requester.applyDragAndDrop(serverPlayer, this.requestIndex, this.requesterId, this.item);
            }
        }
    }
}

