/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.network;

import com.almostreliable.merequester.network.DragAndDropPacket;
import com.almostreliable.merequester.network.Packet;
import com.almostreliable.merequester.network.RequestUpdatePacket;
import com.almostreliable.merequester.network.RequesterSyncPacket;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public final class PacketHandler {
    private static final String PROTOCOL = "1";

    private PacketHandler() {
    }

    public static void onPacketRegistration(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("merequester").versioned(PROTOCOL);
        PacketHandler.registerPacket(registrar, RequesterSyncPacket.ID, RequesterSyncPacket::decode, builder -> builder.client(PacketHandler::handlePacket));
        PacketHandler.registerPacket(registrar, RequestUpdatePacket.ID, RequestUpdatePacket::decode, builder -> builder.server(PacketHandler::handlePacket));
        PacketHandler.registerPacket(registrar, DragAndDropPacket.ID, DragAndDropPacket::decode, builder -> builder.server(PacketHandler::handlePacket));
    }

    private static <P extends Packet> void registerPacket(IPayloadRegistrar registrar, ResourceLocation id, FriendlyByteBuf.Reader<P> decoder, Consumer<IDirectionAwarePayloadHandlerBuilder<P, IPlayPayloadHandler<P>>> factory) {
        registrar.play(id, decoder, factory);
    }

    private static <P extends Packet> void handlePacket(P packet, PlayPayloadContext context) {
        context.player().ifPresent(player -> context.workHandler().execute(() -> packet.handle((Player)player)));
    }
}

