/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.network;

import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.network.Packet;
import com.almostreliable.merequester.requester.abstraction.AbstractRequesterMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class RequestUpdatePacket
implements Packet {
    static final ResourceLocation ID = Utils.getRL("request_update");
    private final UpdateType updateType;
    private final long requesterId;
    private final int requestIndex;
    private boolean state;
    private long amount;
    private long batch;

    public RequestUpdatePacket(long requesterId, int requestIndex, boolean state) {
        this.updateType = UpdateType.STATE;
        this.requesterId = requesterId;
        this.requestIndex = requestIndex;
        this.state = state;
    }

    public RequestUpdatePacket(long requesterId, int requestIndex, long amount, long batch) {
        this.updateType = UpdateType.NUMBERS;
        this.requesterId = requesterId;
        this.requestIndex = requestIndex;
        this.amount = amount;
        this.batch = batch;
    }

    public ResourceLocation id() {
        return ID;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.requesterId);
        buffer.writeVarInt(this.requestIndex);
        buffer.writeVarInt(this.updateType.ordinal());
        if (this.updateType == UpdateType.STATE) {
            buffer.writeBoolean(this.state);
        } else if (this.updateType == UpdateType.NUMBERS) {
            buffer.writeLong(this.amount);
            buffer.writeLong(this.batch);
        } else {
            throw new IllegalStateException("Unknown update type: " + this.updateType);
        }
    }

    static RequestUpdatePacket decode(FriendlyByteBuf buffer) {
        long id = buffer.readLong();
        int index = buffer.readVarInt();
        UpdateType type = UpdateType.values()[buffer.readVarInt()];
        if (type == UpdateType.STATE) {
            return new RequestUpdatePacket(id, index, buffer.readBoolean());
        }
        if (type == UpdateType.NUMBERS) {
            return new RequestUpdatePacket(id, index, buffer.readLong(), buffer.readLong());
        }
        throw new IllegalStateException("Unknown update type: " + type);
    }

    @Override
    public void handle(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof AbstractRequesterMenu) {
            AbstractRequesterMenu requester = (AbstractRequesterMenu)abstractContainerMenu;
            if (this.updateType == UpdateType.STATE) {
                requester.updateRequesterState(this.requesterId, this.requestIndex, this.state);
            } else if (this.updateType == UpdateType.NUMBERS) {
                requester.updateRequesterNumbers(this.requesterId, this.requestIndex, this.amount, this.batch);
            }
        }
    }

    private static enum UpdateType {
        STATE,
        NUMBERS;

    }
}

