/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.network;

import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.client.abstraction.AbstractRequesterScreen;
import com.almostreliable.merequester.network.Packet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public final class RequesterSyncPacket
implements Packet {
    static final ResourceLocation ID = Utils.getRL("requester_sync");
    private final boolean clearData;
    private final long requesterId;
    private final CompoundTag data;

    private RequesterSyncPacket(boolean clearData, long requesterId, CompoundTag data) {
        this.clearData = clearData;
        this.requesterId = requesterId;
        this.data = data;
    }

    public ResourceLocation id() {
        return ID;
    }

    public static RequesterSyncPacket clearData() {
        return new RequesterSyncPacket(true, -1L, new CompoundTag());
    }

    public static RequesterSyncPacket inventory(long requesterId, CompoundTag data) {
        return new RequesterSyncPacket(false, requesterId, data);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.clearData);
        buffer.writeLong(this.requesterId);
        buffer.writeNbt((Tag)this.data);
    }

    static RequesterSyncPacket decode(FriendlyByteBuf buffer) {
        return new RequesterSyncPacket(buffer.readBoolean(), buffer.readLong(), Objects.requireNonNull(buffer.readNbt()));
    }

    @Override
    public void handle(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractRequesterScreen) {
            AbstractRequesterScreen screen2 = (AbstractRequesterScreen)screen;
            screen2.updateFromMenu(this.clearData, this.requesterId, this.data);
        }
    }
}

