/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.orientation.IOrientationStrategy;
import appeng.block.AEBaseEntityBlock;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.requester.FacingWithVerticalSpin;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.RequesterMenu;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class RequesterBlock
extends AEBaseEntityBlock<RequesterBlockEntity> {
    private static final IOrientationStrategy ORIENTATION_STRATEGY = new FacingWithVerticalSpin();
    private static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public RequesterBlock() {
        super(RequesterBlock.metalProps());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack stack, BlockHitResult hit) {
        RequesterBlockEntity entity = (RequesterBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (entity == null || InteractionUtil.isInAlternateUseMode((Player)player)) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide()) {
            MenuOpener.open(RequesterMenu.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)entity));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, RequesterBlockEntity be) {
        return (BlockState)currentState.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(be.isActive()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
    }

    public IOrientationStrategy getOrientationStrategy() {
        return ORIENTATION_STRATEGY;
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.literal((String)" "));
            tooltip.add((Component)Utils.translate("tooltip", String.format("%s_desc", "requester"), new Object[0]).withStyle(ChatFormatting.AQUA));
        } else {
            Utils.addShiftInfoTooltip(tooltip);
        }
    }
}

